"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationStage = exports.CICDStage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * The list of CICD Stages to deploy the SparkCICDStack.
 */
var CICDStage;
(function (CICDStage) {
    CICDStage["STAGING"] = "staging";
    CICDStage["PROD"] = "prod";
})(CICDStage = exports.CICDStage || (exports.CICDStage = {}));
/**
 * ApplicationStage class that creates a CDK Pipelines Stage from an ApplicationStackFactory.
 *
 */
class ApplicationStage extends aws_cdk_lib_1.Stage {
    /**
     * Construct a new instance of the SparkCICDStage class.
     * @param {Construct} scope the Scope of the CDK Construct
     * @param {string} id the ID of the CDK Construct
     * @param {ApplicationStageProps} props the ApplicationStage properties
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        // create the CDK Stack from the ApplicationStackFactory using the proper scope
        const applicationStack = props.applicationStackFactory.createStack(this, props.stage);
        // create CfnOutputs from the variables to expose in env variables for integration tests
        if (props.outputsEnv) {
            this.stackOutputsEnv = {};
            for (let key in props.outputsEnv) {
                const outputName = props.outputsEnv[key];
                this.stackOutputsEnv[key] = applicationStack.node.children.find(v => v?.logicalId?.includes(outputName));
                ;
            }
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
ApplicationStage[_a] = { fqn: "aws-dsf.utils.ApplicationStage", version: "1.0.0-rc.3" };
exports.ApplicationStage = ApplicationStage;
//# sourceMappingURL=data:application/json;base64,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