import { Construct } from 'constructs';
/**
 * Utils for working with Amazon S3 buckets.
 */
export declare class BucketUtils {
    /**
     * Generate a unique Amazon S3 bucket name based on the provided name, CDK construct ID and CDK construct scope.
     * The bucket name is suffixed the AWS account ID, the AWS region and a unique 8 characters hash.
     * The maximum length for name is 26 characters.
     * @param name the name of the bucket
     * @param id the CDK ID of the construct
     * @param scope the current scope where the construct is created (generally `this`)
     * @returns the unique Name for the bucket
     */
    static generateUniqueBucketName(scope: Construct, id: string, name: string): string;
    /**
     * Generate an 8 characters hash of the CDK scope using its path.
     * @param scope the CDK construct scope
     * @returns the hash
     */
    private static generateHash;
}
