import { RemovalPolicy } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * @internal
 * Utils class to work with the CDK context and options
 */
export declare class Context {
    /**
     * Method to revert a DESTROY removal policy to RETAIN if the global removal policy parameter
     * in the CDK context is not set to true.
     * Also create a warning to warn the user if the retention policy has been reverted to RETAIN.
     * @param retentionPolicy The retention policy provided to the construct
     * @return the new retention policy based on the global retention parameter set in the CDK context
     */
    static revertRemovalPolicy(scope: Construct, removalPolicy?: RemovalPolicy): RemovalPolicy;
}
/**
 * @internal
 * Options used in the CDK context
 */
export declare enum ContextOptions {
    DISABLE_CONSTRUCTS_DEPLOYMENT_TRACKING = "@data-solutions-framework-on-aws/disableConstructsDeploymentTracking",
    REMOVE_DATA_ON_DESTROY = "@data-solutions-framework-on-aws/removeDataOnDestroy"
}
