"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionUtils = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
class StepFunctionUtils {
    /**
     * Internal function to convert camel case properties to pascal case as required by AWS Step Functions API
     * @param config
     * @returns config converted to pascal case.
     */
    static camelToPascal(config) {
        if (typeof config !== 'object' || config === null) {
            return config;
        }
        if (Array.isArray(config)) {
            return config.map(item => StepFunctionUtils.camelToPascal(item));
        }
        const pascalObject = {};
        for (const key in config) {
            if (config.hasOwnProperty(key)) {
                const pascalKey = key.replace(/^([a-z]{1})/g, (_, letter) => letter.toUpperCase());
                pascalObject[pascalKey] = StepFunctionUtils.camelToPascal(config[key]);
            }
        }
        return pascalObject;
    }
}
_a = JSII_RTTI_SYMBOL_1;
StepFunctionUtils[_a] = { fqn: "aws-dsf.utils.StepFunctionUtils", version: "1.0.0-rc.3" };
exports.StepFunctionUtils = StepFunctionUtils;
//# sourceMappingURL=data:application/json;base64,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