import { Construct } from 'constructs';
import { TrackedConstructProps } from './tracked-construct-props';
/**
 * @internal
 * A type of CDK Construct that is tracked via a unique code in CloudFormation Stack description.
 * It is used to measure the number of deployments.
 */
export declare class TrackedConstruct extends Construct {
    static readonly DSF_TRACKING_CODE = "uksb-1tupboc21";
    static readonly DSF_OWNED_TAG: string;
    /**
     * Format is "Description (uksb_12345abcde) (version:1.2.3) (tag:construct1,construct2)"
     */
    private static readonly trackingRegExp;
    private static readonly TRACKING_TAG_SEPARATOR;
    /**
     * Constructs a new instance of the TrackedConstruct
     * @param {Construct} scope the Scope of the CDK Construct
     * @param {string} id the ID of the CDK Construct
     * @param {TrackedConstructProps} props the TrackedConstruct [properties] {TrackedConstructProps}
     */
    constructor(scope: Construct, id: string, props: TrackedConstructProps);
    private updateDescription;
    /**
     * Retrieve DSF package.json version
     */
    retrieveVersion(): any;
}
