/**
 * Utilities class used across the different resources
 */
export declare class Utils {
    /**
     * Sanitize a string by removing upper case and replacing special characters except underscore
     * @param {string} toSanitize the string to sanitize
     */
    static stringSanitizer(toSanitize: string): string;
    /**
     * Create a random string to be used as a seed for IAM User password
     * @param {string} name the string to which to append a random string
     */
    static randomize(name: string): string;
    /**
     * Read a YAML file from the path provided and return it
     * @param {string} path the path to the file
     */
    static readYamlDocument(path: string): string;
    /**
     * Take a document stored as string and load it as YAML
     * @param {string} document the document stored as string
     */
    static loadYaml(document: string): any;
    /**
     * Convert a string to PascalCase
     * @param text
     * @returns
     */
    static toPascalCase(text: string): string;
}
