"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Utils = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const fs = require("fs");
const yaml = require("js-yaml");
/**
 * Utilities class used across the different resources
 */
class Utils {
    /**
     * Sanitize a string by removing upper case and replacing special characters except underscore
     * @param {string} toSanitize the string to sanitize
     */
    static stringSanitizer(toSanitize) {
        return toSanitize.toLowerCase().replace(/[^\w\s]/gi, '');
    }
    /**
     * Create a random string to be used as a seed for IAM User password
     * @param {string} name the string to which to append a random string
     */
    static randomize(name) {
        return `${name}-${Math.random().toString(36).substring(2, 9).toUpperCase()}`;
    }
    /**
     * Read a YAML file from the path provided and return it
     * @param {string} path the path to the file
     */
    static readYamlDocument(path) {
        try {
            const doc = fs.readFileSync(path, 'utf8');
            return doc;
        }
        catch (e) {
            console.log(e + ' for path: ' + path);
            throw e;
        }
    }
    /**
     * Take a document stored as string and load it as YAML
     * @param {string} document the document stored as string
     */
    static loadYaml(document) {
        return yaml.load(document);
    }
    /**
     * Convert a string to PascalCase
     * @param text
     * @returns
     */
    static toPascalCase(text) {
        // Split the text into words
        const words = text.match(/[a-z]+/gi);
        if (words) {
            // Capitalize first letter of each word
            words.forEach((word, index) => {
                words[index] = word.charAt(0).toUpperCase() + word.slice(1).toLowerCase();
            });
            // Join the words back into a string
            return words.join('');
        }
        return text;
    }
}
_a = JSII_RTTI_SYMBOL_1;
Utils[_a] = { fqn: "aws-dsf.utils.Utils", version: "1.0.0-rc.3" };
exports.Utils = Utils;
//# sourceMappingURL=data:application/json;base64,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