import { RemovalPolicy } from 'aws-cdk-lib';
import { IVpc, IVpcEndpoint } from 'aws-cdk-lib/aws-ec2';
import { IRole } from 'aws-cdk-lib/aws-iam';
import { IKey } from 'aws-cdk-lib/aws-kms';
import { ILogGroup } from 'aws-cdk-lib/aws-logs';
import { Construct } from 'constructs';
/**
 * A network configuration created by the vpcBootstrap function.
 * @param {IVpc} vpc the vpc created by the function vpcBootstrap
 * @param {IVpcEndpoint} s3GatewayVpcEndpoint the vpc endpoint attached to the vpc the function vpcBootstrap created
 * @param {ILogGroup} vpcFlowLogLogGroup the log group used to store the vpc flow logs
 * @param {IRole} iamFlowLogRole the role used to store the vpc flow logs
*/
export interface NetworkConfiguration {
    readonly vpc: IVpc;
    readonly s3GatewayVpcEndpoint: IVpcEndpoint;
    readonly vpcFlowLogLogGroup: ILogGroup;
    readonly iamFlowLogRole: IRole;
}
/**
 * @internal
 * Create a VPC with the provided CIDR and attach to it an Amazon S3 Gateway Vpc Endpoint
 * @param {Construct} scope The scope of the stack where the VPC will be created
 * @param {string} vpcCidr The cidr for vpc
 * @param {Key} logKmsKey The KMS key used to encrypt the VPC flow log
 * @param {RemovalPolicy} vpcFlowlogRemovalPolicy The removal policy for vpc flowlog in cloudwatch log
 * @param {string} eksClusterName The name used to tag the subnet and vpc
 * @param {string} emrAppName The name used to tag the subnet and vpc
 */
export declare function vpcBootstrap(scope: Construct, vpcCidr: string, logKmsKey: IKey, vpcFlowlogRemovalPolicy?: RemovalPolicy, eksClusterName?: string, emrAppName?: string, vpcFlowLogRole?: IRole): NetworkConfiguration;
