"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgeDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("@aws-cdk/aws-events");
const core_1 = require("@aws-cdk/core");
/**
 * Use an Event Bridge event bus as a Lambda destination.
 *
 * If no event bus is specified, the default event bus is used.
 *
 * @stability stable
 */
class EventBridgeDestination {
    /**
     * @default - use the default event bus
     * @stability stable
     */
    constructor(eventBus) {
        this.eventBus = eventBus;
    }
    /**
     * Returns a destination configuration.
     *
     * @stability stable
     */
    bind(_scope, fn, _options) {
        if (this.eventBus) {
            this.eventBus.grantPutEventsTo(fn);
            return {
                destination: this.eventBus.eventBusArn,
            };
        }
        const existingDefaultEventBus = _scope.node.tryFindChild('DefaultEventBus');
        let eventBus = existingDefaultEventBus || events.EventBus.fromEventBusArn(_scope, 'DefaultEventBus', core_1.Stack.of(fn).formatArn({
            service: 'events',
            resource: 'event-bus',
            resourceName: 'default',
        }));
        eventBus.grantPutEventsTo(fn);
        return {
            destination: eventBus.eventBusArn,
        };
    }
}
exports.EventBridgeDestination = EventBridgeDestination;
_a = JSII_RTTI_SYMBOL_1;
EventBridgeDestination[_a] = { fqn: "@aws-cdk/aws-lambda-destinations.EventBridgeDestination", version: "1.105.0" };
//# sourceMappingURL=data:application/json;base64,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