"""
    Svix API

    Welcome to the Svix API documentation!  Useful links: [Homepage](https://www.svix.com) | [Support email](mailto:support+docs@svix.com) | [Blog](https://www.svix.com/blog/) | [Slack Community](https://www.svix.com/slack/)  # Introduction  This is the reference documentation and schemas for the [Svix webhook service](https://www.svix.com) API. For tutorials and other documentation please refer to [the documentation](https://docs.svix.com).  ## Main concepts  In Svix you have four important entities you will be interacting with:  - `messages`: these are the webhooks being sent. They can have contents and a few other properties. - `application`: this is where `messages` are sent to. Usually you want to create one application for each user on your platform. - `endpoint`: endpoints are the URLs messages will be sent to. Each application can have multiple `endpoints` and each message sent to that application will be sent to all of them (unless they are not subscribed to the sent event type). - `event-type`: event types are identifiers denoting the type of the message being sent. Event types are primarily used to decide which events are sent to which endpoint.   ## Authentication  Get your authentication token (`AUTH_TOKEN`) from the [Svix dashboard](https://dashboard.svix.com) and use it as part of the `Authorization` header as such: `Authorization: Bearer ${AUTH_TOKEN}`.  <SecurityDefinitions />   ## Code samples  The code samples assume you already have the respective libraries installed and you know how to use them. For the latest information on how to do that, please refer to [the documentation](https://docs.svix.com/).   ## Idempotency  Svix supports [idempotency](https://en.wikipedia.org/wiki/Idempotence) for safely retrying requests without accidentally performing the same operation twice. This is useful when an API call is disrupted in transit and you do not receive a response.  To perform an idempotent request, pass the idempotency key in the `Idempotency-Key` header to the request. The idempotency key should be a unique value generated by the client. You can create the key in however way you like, though we suggest using UUID v4, or any other string with enough entropy to avoid collisions.  Svix's idempotency works by saving the resulting status code and body of the first request made for any given idempotency key for any successful request. Subsequent requests with the same key return the same result.  Please note that idempotency is only supported for `POST` requests.   ## Cross-Origin Resource Sharing  This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/). And that allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.   # noqa: E501

    The version of the OpenAPI document: 1.4
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from svix.openapi_client.api_client import ApiClient, Endpoint as _Endpoint
from svix.openapi_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from svix.openapi_client.model.endpoint_headers_in import EndpointHeadersIn
from svix.openapi_client.model.endpoint_headers_out import EndpointHeadersOut
from svix.openapi_client.model.endpoint_in import EndpointIn
from svix.openapi_client.model.endpoint_out import EndpointOut
from svix.openapi_client.model.endpoint_secret_out import EndpointSecretOut
from svix.openapi_client.model.endpoint_secret_rotate_in import EndpointSecretRotateIn
from svix.openapi_client.model.endpoint_stats import EndpointStats
from svix.openapi_client.model.endpoint_update import EndpointUpdate
from svix.openapi_client.model.event_example_in import EventExampleIn
from svix.openapi_client.model.http_validation_error import HTTPValidationError
from svix.openapi_client.model.http_error_out import HttpErrorOut
from svix.openapi_client.model.list_response_endpoint_out import ListResponseEndpointOut
from svix.openapi_client.model.message_out import MessageOut
from svix.openapi_client.model.recover_in import RecoverIn


class EndpointApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_endpoint_api_v1_app_app_id_endpoint_post(
            self,
            app_id,
            endpoint_in,
            **kwargs
        ):
            """Create Endpoint  # noqa: E501

            Create a new endpoint for the application.  When `secret` is `null` the secret is automatically generated (recommended)  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_endpoint_api_v1_app_app_id_endpoint_post(app_id, endpoint_in, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str):
                endpoint_in (EndpointIn):

            Keyword Args:
                idempotency_key (str): The request's idempotency key. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EndpointOut
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['endpoint_in'] = \
                endpoint_in
            return self.call_with_http_info(**kwargs)

        self.create_endpoint_api_v1_app_app_id_endpoint_post = _Endpoint(
            settings={
                'response_type': (EndpointOut,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/app/{app_id}/endpoint/',
                'operation_id': 'create_endpoint_api_v1_app_app_id_endpoint_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_id',
                    'endpoint_in',
                    'idempotency_key',
                ],
                'required': [
                    'app_id',
                    'endpoint_in',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'app_id',
                ]
            },
            root_map={
                'validations': {
                    ('app_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_id':
                        (str,),
                    'endpoint_in':
                        (EndpointIn,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'app_id': 'app_id',
                    'idempotency_key': 'idempotency-key',
                },
                'location_map': {
                    'app_id': 'path',
                    'endpoint_in': 'body',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_endpoint_api_v1_app_app_id_endpoint_post
        )

        def __delete_endpoint_api_v1_app_app_id_endpoint_endpoint_id_delete(
            self,
            endpoint_id,
            app_id,
            **kwargs
        ):
            """Delete Endpoint  # noqa: E501

            Delete an endpoint.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_endpoint_api_v1_app_app_id_endpoint_endpoint_id_delete(endpoint_id, app_id, async_req=True)
            >>> result = thread.get()

            Args:
                endpoint_id (str):
                app_id (str):

            Keyword Args:
                idempotency_key (str): The request's idempotency key. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['endpoint_id'] = \
                endpoint_id
            kwargs['app_id'] = \
                app_id
            return self.call_with_http_info(**kwargs)

        self.delete_endpoint_api_v1_app_app_id_endpoint_endpoint_id_delete = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/app/{app_id}/endpoint/{endpoint_id}/',
                'operation_id': 'delete_endpoint_api_v1_app_app_id_endpoint_endpoint_id_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'endpoint_id',
                    'app_id',
                    'idempotency_key',
                ],
                'required': [
                    'endpoint_id',
                    'app_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'endpoint_id',
                    'app_id',
                ]
            },
            root_map={
                'validations': {
                    ('endpoint_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                    ('app_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'endpoint_id':
                        (str,),
                    'app_id':
                        (str,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'endpoint_id': 'endpoint_id',
                    'app_id': 'app_id',
                    'idempotency_key': 'idempotency-key',
                },
                'location_map': {
                    'endpoint_id': 'path',
                    'app_id': 'path',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_endpoint_api_v1_app_app_id_endpoint_endpoint_id_delete
        )

        def __get_endpoint_api_v1_app_app_id_endpoint_endpoint_id_get(
            self,
            endpoint_id,
            app_id,
            **kwargs
        ):
            """Get Endpoint  # noqa: E501

            Get an application.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_endpoint_api_v1_app_app_id_endpoint_endpoint_id_get(endpoint_id, app_id, async_req=True)
            >>> result = thread.get()

            Args:
                endpoint_id (str):
                app_id (str):

            Keyword Args:
                idempotency_key (str): The request's idempotency key. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EndpointOut
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['endpoint_id'] = \
                endpoint_id
            kwargs['app_id'] = \
                app_id
            return self.call_with_http_info(**kwargs)

        self.get_endpoint_api_v1_app_app_id_endpoint_endpoint_id_get = _Endpoint(
            settings={
                'response_type': (EndpointOut,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/app/{app_id}/endpoint/{endpoint_id}/',
                'operation_id': 'get_endpoint_api_v1_app_app_id_endpoint_endpoint_id_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'endpoint_id',
                    'app_id',
                    'idempotency_key',
                ],
                'required': [
                    'endpoint_id',
                    'app_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'endpoint_id',
                    'app_id',
                ]
            },
            root_map={
                'validations': {
                    ('endpoint_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                    ('app_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'endpoint_id':
                        (str,),
                    'app_id':
                        (str,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'endpoint_id': 'endpoint_id',
                    'app_id': 'app_id',
                    'idempotency_key': 'idempotency-key',
                },
                'location_map': {
                    'endpoint_id': 'path',
                    'app_id': 'path',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_endpoint_api_v1_app_app_id_endpoint_endpoint_id_get
        )

        def __get_endpoint_headers_api_v1_app_app_id_endpoint_endpoint_id_headers_get(
            self,
            endpoint_id,
            app_id,
            **kwargs
        ):
            """Get Endpoint Headers  # noqa: E501

            Get the additional headers to be sent with the webhook  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_endpoint_headers_api_v1_app_app_id_endpoint_endpoint_id_headers_get(endpoint_id, app_id, async_req=True)
            >>> result = thread.get()

            Args:
                endpoint_id (str):
                app_id (str):

            Keyword Args:
                idempotency_key (str): The request's idempotency key. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EndpointHeadersOut
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['endpoint_id'] = \
                endpoint_id
            kwargs['app_id'] = \
                app_id
            return self.call_with_http_info(**kwargs)

        self.get_endpoint_headers_api_v1_app_app_id_endpoint_endpoint_id_headers_get = _Endpoint(
            settings={
                'response_type': (EndpointHeadersOut,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/app/{app_id}/endpoint/{endpoint_id}/headers/',
                'operation_id': 'get_endpoint_headers_api_v1_app_app_id_endpoint_endpoint_id_headers_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'endpoint_id',
                    'app_id',
                    'idempotency_key',
                ],
                'required': [
                    'endpoint_id',
                    'app_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'endpoint_id',
                    'app_id',
                ]
            },
            root_map={
                'validations': {
                    ('endpoint_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                    ('app_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'endpoint_id':
                        (str,),
                    'app_id':
                        (str,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'endpoint_id': 'endpoint_id',
                    'app_id': 'app_id',
                    'idempotency_key': 'idempotency-key',
                },
                'location_map': {
                    'endpoint_id': 'path',
                    'app_id': 'path',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_endpoint_headers_api_v1_app_app_id_endpoint_endpoint_id_headers_get
        )

        def __get_endpoint_secret_api_v1_app_app_id_endpoint_endpoint_id_secret_get(
            self,
            endpoint_id,
            app_id,
            **kwargs
        ):
            """Get Endpoint Secret  # noqa: E501

            Get the endpoint's signing secret.  This is used to verify the authenticity of the webhook. For more information please refer to [the consuming webhooks docs](https://docs.svix.com/consuming-webhooks/).  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_endpoint_secret_api_v1_app_app_id_endpoint_endpoint_id_secret_get(endpoint_id, app_id, async_req=True)
            >>> result = thread.get()

            Args:
                endpoint_id (str):
                app_id (str):

            Keyword Args:
                idempotency_key (str): The request's idempotency key. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EndpointSecretOut
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['endpoint_id'] = \
                endpoint_id
            kwargs['app_id'] = \
                app_id
            return self.call_with_http_info(**kwargs)

        self.get_endpoint_secret_api_v1_app_app_id_endpoint_endpoint_id_secret_get = _Endpoint(
            settings={
                'response_type': (EndpointSecretOut,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/app/{app_id}/endpoint/{endpoint_id}/secret/',
                'operation_id': 'get_endpoint_secret_api_v1_app_app_id_endpoint_endpoint_id_secret_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'endpoint_id',
                    'app_id',
                    'idempotency_key',
                ],
                'required': [
                    'endpoint_id',
                    'app_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'endpoint_id',
                    'app_id',
                ]
            },
            root_map={
                'validations': {
                    ('endpoint_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                    ('app_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'endpoint_id':
                        (str,),
                    'app_id':
                        (str,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'endpoint_id': 'endpoint_id',
                    'app_id': 'app_id',
                    'idempotency_key': 'idempotency-key',
                },
                'location_map': {
                    'endpoint_id': 'path',
                    'app_id': 'path',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_endpoint_secret_api_v1_app_app_id_endpoint_endpoint_id_secret_get
        )

        def __get_endpoint_stats_api_v1_app_app_id_endpoint_endpoint_id_stats_get(
            self,
            endpoint_id,
            app_id,
            **kwargs
        ):
            """Get Endpoint Stats  # noqa: E501

            Get basic statistics for the endpoint.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_endpoint_stats_api_v1_app_app_id_endpoint_endpoint_id_stats_get(endpoint_id, app_id, async_req=True)
            >>> result = thread.get()

            Args:
                endpoint_id (str):
                app_id (str):

            Keyword Args:
                idempotency_key (str): The request's idempotency key. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EndpointStats
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['endpoint_id'] = \
                endpoint_id
            kwargs['app_id'] = \
                app_id
            return self.call_with_http_info(**kwargs)

        self.get_endpoint_stats_api_v1_app_app_id_endpoint_endpoint_id_stats_get = _Endpoint(
            settings={
                'response_type': (EndpointStats,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/app/{app_id}/endpoint/{endpoint_id}/stats/',
                'operation_id': 'get_endpoint_stats_api_v1_app_app_id_endpoint_endpoint_id_stats_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'endpoint_id',
                    'app_id',
                    'idempotency_key',
                ],
                'required': [
                    'endpoint_id',
                    'app_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'endpoint_id',
                    'app_id',
                ]
            },
            root_map={
                'validations': {
                    ('endpoint_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                    ('app_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'endpoint_id':
                        (str,),
                    'app_id':
                        (str,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'endpoint_id': 'endpoint_id',
                    'app_id': 'app_id',
                    'idempotency_key': 'idempotency-key',
                },
                'location_map': {
                    'endpoint_id': 'path',
                    'app_id': 'path',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_endpoint_stats_api_v1_app_app_id_endpoint_endpoint_id_stats_get
        )

        def __list_endpoints_api_v1_app_app_id_endpoint_get(
            self,
            app_id,
            **kwargs
        ):
            """List Endpoints  # noqa: E501

            List the application's endpoints.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_endpoints_api_v1_app_app_id_endpoint_get(app_id, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str):

            Keyword Args:
                iterator (str): [optional]
                limit (int): [optional] if omitted the server will use the default value of 50
                idempotency_key (str): The request's idempotency key. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListResponseEndpointOut
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            return self.call_with_http_info(**kwargs)

        self.list_endpoints_api_v1_app_app_id_endpoint_get = _Endpoint(
            settings={
                'response_type': (ListResponseEndpointOut,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/app/{app_id}/endpoint/',
                'operation_id': 'list_endpoints_api_v1_app_app_id_endpoint_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_id',
                    'iterator',
                    'limit',
                    'idempotency_key',
                ],
                'required': [
                    'app_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'app_id',
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('app_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                    ('limit',): {

                        'inclusive_maximum': 250,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_id':
                        (str,),
                    'iterator':
                        (str,),
                    'limit':
                        (int,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'app_id': 'app_id',
                    'iterator': 'iterator',
                    'limit': 'limit',
                    'idempotency_key': 'idempotency-key',
                },
                'location_map': {
                    'app_id': 'path',
                    'iterator': 'query',
                    'limit': 'query',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_endpoints_api_v1_app_app_id_endpoint_get
        )

        def __patch_endpoint_headers_api_v1_app_app_id_endpoint_endpoint_id_headers_patch(
            self,
            app_id,
            endpoint_id,
            endpoint_headers_in,
            **kwargs
        ):
            """Patch Endpoint Headers  # noqa: E501

            Partially set the additional headers to be sent with the webhook  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.patch_endpoint_headers_api_v1_app_app_id_endpoint_endpoint_id_headers_patch(app_id, endpoint_id, endpoint_headers_in, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str):
                endpoint_id (str):
                endpoint_headers_in (EndpointHeadersIn):

            Keyword Args:
                idempotency_key (str): The request's idempotency key. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['endpoint_id'] = \
                endpoint_id
            kwargs['endpoint_headers_in'] = \
                endpoint_headers_in
            return self.call_with_http_info(**kwargs)

        self.patch_endpoint_headers_api_v1_app_app_id_endpoint_endpoint_id_headers_patch = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/app/{app_id}/endpoint/{endpoint_id}/headers/',
                'operation_id': 'patch_endpoint_headers_api_v1_app_app_id_endpoint_endpoint_id_headers_patch',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_id',
                    'endpoint_id',
                    'endpoint_headers_in',
                    'idempotency_key',
                ],
                'required': [
                    'app_id',
                    'endpoint_id',
                    'endpoint_headers_in',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'app_id',
                    'endpoint_id',
                ]
            },
            root_map={
                'validations': {
                    ('app_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                    ('endpoint_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_id':
                        (str,),
                    'endpoint_id':
                        (str,),
                    'endpoint_headers_in':
                        (EndpointHeadersIn,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'app_id': 'app_id',
                    'endpoint_id': 'endpoint_id',
                    'idempotency_key': 'idempotency-key',
                },
                'location_map': {
                    'app_id': 'path',
                    'endpoint_id': 'path',
                    'endpoint_headers_in': 'body',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__patch_endpoint_headers_api_v1_app_app_id_endpoint_endpoint_id_headers_patch
        )

        def __recover_failed_webhooks_api_v1_app_app_id_endpoint_endpoint_id_recover_post(
            self,
            app_id,
            endpoint_id,
            recover_in,
            **kwargs
        ):
            """Recover Failed Webhooks  # noqa: E501

            Resend all failed messages since a given time.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.recover_failed_webhooks_api_v1_app_app_id_endpoint_endpoint_id_recover_post(app_id, endpoint_id, recover_in, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str):
                endpoint_id (str):
                recover_in (RecoverIn):

            Keyword Args:
                idempotency_key (str): The request's idempotency key. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['endpoint_id'] = \
                endpoint_id
            kwargs['recover_in'] = \
                recover_in
            return self.call_with_http_info(**kwargs)

        self.recover_failed_webhooks_api_v1_app_app_id_endpoint_endpoint_id_recover_post = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/app/{app_id}/endpoint/{endpoint_id}/recover/',
                'operation_id': 'recover_failed_webhooks_api_v1_app_app_id_endpoint_endpoint_id_recover_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_id',
                    'endpoint_id',
                    'recover_in',
                    'idempotency_key',
                ],
                'required': [
                    'app_id',
                    'endpoint_id',
                    'recover_in',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'app_id',
                    'endpoint_id',
                ]
            },
            root_map={
                'validations': {
                    ('app_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                    ('endpoint_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_id':
                        (str,),
                    'endpoint_id':
                        (str,),
                    'recover_in':
                        (RecoverIn,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'app_id': 'app_id',
                    'endpoint_id': 'endpoint_id',
                    'idempotency_key': 'idempotency-key',
                },
                'location_map': {
                    'app_id': 'path',
                    'endpoint_id': 'path',
                    'recover_in': 'body',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__recover_failed_webhooks_api_v1_app_app_id_endpoint_endpoint_id_recover_post
        )

        def __rotate_endpoint_secret_api_v1_app_app_id_endpoint_endpoint_id_secret_rotate_post(
            self,
            endpoint_id,
            app_id,
            endpoint_secret_rotate_in,
            **kwargs
        ):
            """Rotate Endpoint Secret  # noqa: E501

            Rotates the endpoint's signing secret.  The previous secret will be valid for the next 24 hours.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.rotate_endpoint_secret_api_v1_app_app_id_endpoint_endpoint_id_secret_rotate_post(endpoint_id, app_id, endpoint_secret_rotate_in, async_req=True)
            >>> result = thread.get()

            Args:
                endpoint_id (str):
                app_id (str):
                endpoint_secret_rotate_in (EndpointSecretRotateIn):

            Keyword Args:
                idempotency_key (str): The request's idempotency key. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['endpoint_id'] = \
                endpoint_id
            kwargs['app_id'] = \
                app_id
            kwargs['endpoint_secret_rotate_in'] = \
                endpoint_secret_rotate_in
            return self.call_with_http_info(**kwargs)

        self.rotate_endpoint_secret_api_v1_app_app_id_endpoint_endpoint_id_secret_rotate_post = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/app/{app_id}/endpoint/{endpoint_id}/secret/rotate/',
                'operation_id': 'rotate_endpoint_secret_api_v1_app_app_id_endpoint_endpoint_id_secret_rotate_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'endpoint_id',
                    'app_id',
                    'endpoint_secret_rotate_in',
                    'idempotency_key',
                ],
                'required': [
                    'endpoint_id',
                    'app_id',
                    'endpoint_secret_rotate_in',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'endpoint_id',
                    'app_id',
                ]
            },
            root_map={
                'validations': {
                    ('endpoint_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                    ('app_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'endpoint_id':
                        (str,),
                    'app_id':
                        (str,),
                    'endpoint_secret_rotate_in':
                        (EndpointSecretRotateIn,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'endpoint_id': 'endpoint_id',
                    'app_id': 'app_id',
                    'idempotency_key': 'idempotency-key',
                },
                'location_map': {
                    'endpoint_id': 'path',
                    'app_id': 'path',
                    'endpoint_secret_rotate_in': 'body',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__rotate_endpoint_secret_api_v1_app_app_id_endpoint_endpoint_id_secret_rotate_post
        )

        def __send_event_type_example_message_api_v1_app_app_id_endpoint_endpoint_id_send_example_post(
            self,
            app_id,
            endpoint_id,
            event_example_in,
            **kwargs
        ):
            """Send Event Type Example Message  # noqa: E501

            Send an example message for event  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.send_event_type_example_message_api_v1_app_app_id_endpoint_endpoint_id_send_example_post(app_id, endpoint_id, event_example_in, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str):
                endpoint_id (str):
                event_example_in (EventExampleIn):

            Keyword Args:
                idempotency_key (str): The request's idempotency key. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MessageOut
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['endpoint_id'] = \
                endpoint_id
            kwargs['event_example_in'] = \
                event_example_in
            return self.call_with_http_info(**kwargs)

        self.send_event_type_example_message_api_v1_app_app_id_endpoint_endpoint_id_send_example_post = _Endpoint(
            settings={
                'response_type': (MessageOut,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/app/{app_id}/endpoint/{endpoint_id}/send-example/',
                'operation_id': 'send_event_type_example_message_api_v1_app_app_id_endpoint_endpoint_id_send_example_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_id',
                    'endpoint_id',
                    'event_example_in',
                    'idempotency_key',
                ],
                'required': [
                    'app_id',
                    'endpoint_id',
                    'event_example_in',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'app_id',
                    'endpoint_id',
                ]
            },
            root_map={
                'validations': {
                    ('app_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                    ('endpoint_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_id':
                        (str,),
                    'endpoint_id':
                        (str,),
                    'event_example_in':
                        (EventExampleIn,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'app_id': 'app_id',
                    'endpoint_id': 'endpoint_id',
                    'idempotency_key': 'idempotency-key',
                },
                'location_map': {
                    'app_id': 'path',
                    'endpoint_id': 'path',
                    'event_example_in': 'body',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__send_event_type_example_message_api_v1_app_app_id_endpoint_endpoint_id_send_example_post
        )

        def __update_endpoint_api_v1_app_app_id_endpoint_endpoint_id_put(
            self,
            endpoint_id,
            app_id,
            endpoint_update,
            **kwargs
        ):
            """Update Endpoint  # noqa: E501

            Update an endpoint.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_endpoint_api_v1_app_app_id_endpoint_endpoint_id_put(endpoint_id, app_id, endpoint_update, async_req=True)
            >>> result = thread.get()

            Args:
                endpoint_id (str):
                app_id (str):
                endpoint_update (EndpointUpdate):

            Keyword Args:
                idempotency_key (str): The request's idempotency key. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EndpointOut
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['endpoint_id'] = \
                endpoint_id
            kwargs['app_id'] = \
                app_id
            kwargs['endpoint_update'] = \
                endpoint_update
            return self.call_with_http_info(**kwargs)

        self.update_endpoint_api_v1_app_app_id_endpoint_endpoint_id_put = _Endpoint(
            settings={
                'response_type': (EndpointOut,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/app/{app_id}/endpoint/{endpoint_id}/',
                'operation_id': 'update_endpoint_api_v1_app_app_id_endpoint_endpoint_id_put',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'endpoint_id',
                    'app_id',
                    'endpoint_update',
                    'idempotency_key',
                ],
                'required': [
                    'endpoint_id',
                    'app_id',
                    'endpoint_update',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'endpoint_id',
                    'app_id',
                ]
            },
            root_map={
                'validations': {
                    ('endpoint_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                    ('app_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'endpoint_id':
                        (str,),
                    'app_id':
                        (str,),
                    'endpoint_update':
                        (EndpointUpdate,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'endpoint_id': 'endpoint_id',
                    'app_id': 'app_id',
                    'idempotency_key': 'idempotency-key',
                },
                'location_map': {
                    'endpoint_id': 'path',
                    'app_id': 'path',
                    'endpoint_update': 'body',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_endpoint_api_v1_app_app_id_endpoint_endpoint_id_put
        )

        def __update_endpoint_headers_api_v1_app_app_id_endpoint_endpoint_id_headers_put(
            self,
            app_id,
            endpoint_id,
            endpoint_headers_in,
            **kwargs
        ):
            """Update Endpoint Headers  # noqa: E501

            Set the additional headers to be sent with the webhook  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_endpoint_headers_api_v1_app_app_id_endpoint_endpoint_id_headers_put(app_id, endpoint_id, endpoint_headers_in, async_req=True)
            >>> result = thread.get()

            Args:
                app_id (str):
                endpoint_id (str):
                endpoint_headers_in (EndpointHeadersIn):

            Keyword Args:
                idempotency_key (str): The request's idempotency key. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_id'] = \
                app_id
            kwargs['endpoint_id'] = \
                endpoint_id
            kwargs['endpoint_headers_in'] = \
                endpoint_headers_in
            return self.call_with_http_info(**kwargs)

        self.update_endpoint_headers_api_v1_app_app_id_endpoint_endpoint_id_headers_put = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/app/{app_id}/endpoint/{endpoint_id}/headers/',
                'operation_id': 'update_endpoint_headers_api_v1_app_app_id_endpoint_endpoint_id_headers_put',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_id',
                    'endpoint_id',
                    'endpoint_headers_in',
                    'idempotency_key',
                ],
                'required': [
                    'app_id',
                    'endpoint_id',
                    'endpoint_headers_in',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'app_id',
                    'endpoint_id',
                ]
            },
            root_map={
                'validations': {
                    ('app_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                    ('endpoint_id',): {
                        'max_length': 256,
                        'min_length': 1,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_id':
                        (str,),
                    'endpoint_id':
                        (str,),
                    'endpoint_headers_in':
                        (EndpointHeadersIn,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'app_id': 'app_id',
                    'endpoint_id': 'endpoint_id',
                    'idempotency_key': 'idempotency-key',
                },
                'location_map': {
                    'app_id': 'path',
                    'endpoint_id': 'path',
                    'endpoint_headers_in': 'body',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_endpoint_headers_api_v1_app_app_id_endpoint_endpoint_id_headers_put
        )
