import enum

class Language(enum.Enum):
    af = ("Afrikaans")
    ak = ("Akan")
    ay = ("Aymara")
    bh = ("Bihari")
    sq = ("Albanian")
    am = ("Amharic")
    an = ("Aragonese")
    ar = ("Arabic")
    hy = ("Armenian")
    az = ("Azerbaijani")
    eu = ("Basque")
    ba = ("Bashkir")
    bo = ("Tibetan")
    be = ("Belarusian")
    bm = ("Bambara")
    bho = ("Bhojpuri")
    bn = ("Bangla")
    bs = ("Bosnian")
    bg = ("Bulgarian")
    ca = ("Catalan")
    ceb = ("Cebuano")
    ckb = ("Kurdish (Sorani)")
    doi = ("Dogri")
    ny = ("Chichewa")
    co = ("Corsican")
    hr = ("Croatian")
    cs = ("Czech")
    da = ("Danish")
    dv = ("Divehi")
    nl = ("Dutch")
    ee = ("Ewe")
    en = ("English")
    eo = ("Esperanto")
    et = ("Estonian")
    fo = ("Faroese")
    tl = ("Filipino")
    fi = ("Finnish")
    fr = ("French")
    fy = ("Frisian")
    gl = ("Galician")
    ka = ("Georgian")
    de = ("German")
    el = ("Greek")
    gom = ("Goan Konkani")
    gn = ("Guarani")
    gu = ("Gujarati")
    ht = ("Haitian Creole")
    ha = ("Hausa")
    haw = ("Hawaiian")
    hsb = ("Upper Sorbian")
    ikt = ("Inuinnaqtun")
    iw = ("Hebrew")
    iu = ("Inuktitut")
    iu_latn = ("Inuktitut (Latin)")
    hi = ("Hindi")
    hmn = ("Hmong")
    hu = ("Hungarian")
    is_ = ("Icelandic")
    ig = ("Igbo")
    id_ = ("Indonesian")
    ilo = ("Iloko")
    ga = ("Irish")
    it = ("Italian")
    ja = ("Japanese")
    jw = ("Javanese")
    kn = ("Kannada")
    kk = ("Kazakh")
    km = ("Khmer")
    kri = ("Krio")
    lg = ("Luganda")
    ln = ("Lingala")
    lus = ("Mizo")
    rw = ("Kinyarwanda")
    ko = ("Korean")
    ku = ("Kurdish (Central)")
    ky = ("Kyrgyz")
    lo = ("Lao")
    la = ("Latin")
    lv = ("Latvian")
    lt = ("Lithuanian")
    lb = ("Luxembourgish")
    mai = ("Maithili")
    mk = ("Macedonian")
    mg = ("Malagasy")
    ms = ("Malay")
    ml = ("Malayalam")
    mt = ("Maltese")
    mi = ("Maori")
    mr = ("Marathi")
    mn = ("Mongolian")
    mni = ("Manipuri (Meitei Mayek)")
    mn_cyrl = ("Mongolian (Cyrillic)")
    cnr = ("Montenegrin")
    my = ("Myanmar (Burmese)")
    ne = ("Nepali")
    no = ("Norwegian")
    nso = ("Northern Sotho")
    om = ("Oromo")
    or_ = ("Odia")
    ps = ("Pashto")
    qu = ("Quechua")
    fa = ("Persian")
    pl = ("Polish")
    pt_br = ("Portuguese (Brazil)")
    pa = ("Punjabi")
    ro = ("Romanian")
    ru = ("Russian")
    sm = ("Samoan")
    gd = ("Scots Gaelic")
    st = ("Sesotho")
    sn = ("Shona")
    sd = ("Sindhi")
    si = ("Sinhala")
    sk = ("Slovak")
    sl = ("Slovenian")
    so = ("Somali")
    es = ("Spanish")
    es_mx = ("Spanish (Mexico)")
    sa = ("Sanskrit")
    su = ("Sundanese")
    sw = ("Swahili")
    sv = ("Swedish")
    tg = ("Tajik")
    ta = ("Tamil")
    tt = ("Tatar")
    te = ("Telugu")
    th = ("Thai")
    ti = ("Tigrinya")
    tr = ("Turkish")
    ts = ("Tsonga")
    tk = ("Turkmen")
    uk = ("Ukrainian")
    ur = ("Urdu")
    ug = ("Uyghur")
    uz = ("Uzbek")
    vi = ("Vietnamese")
    cy = ("Welsh")
    xh = ("Xhosa")
    yi = ("Yiddish")
    yo = ("Yoruba")
    zu = ("Zulu")
    he = ("Hebrew")
    as_ = ("Assamese")
    fil = ("Filipino")
    fj = ("Fijian")
    fr_ca = ("French (Canada)")
    kmr = ("Kurdish (Northern)")
    mww = ("Hmong Daw")
    nb = ("Norwegian")
    otq = ("Querétaro Otomi")
    prs = ("Dari")
    pt_pt = ("Portuguese (Portugal)")
    sr_cyrl = ("Serbian (Cyrillic)")
    sr_latn = ("Serbian (Latin)")
    tlh_latn = ("Klingon (Latin)")
    tlh_piqd = ("Klingon (pIqaD)")
    to = ("Tongan")
    ty = ("Tahitian")
    yua = ("Yucatec Maya")
    yue = ("Chinese (Cantonese, Traditional)")
    zh_cn = ("Chinese (Simplified)")
    zh_tw = ("Chinese (Traditional)")
    zh_lit = ("Chinese (Literary)")


    def __init__(self, lang_name):
        self.lang_name = lang_name        

class AudioLanguage(enum.Enum):
    af_ZA = (Language.af, "Afrikaans (South Africa)")
    am_ET = (Language.am, "Amharic (Ethiopia)")
    an_ES = (Language.an, "Aragonese (Spain)")
    # arabic
    ar_AE = (Language.ar, "Arabic (United Arab Emirates)")
    ar_BH = (Language.ar, "Arabic (Bahrain)")
    ar_DZ = (Language.ar, "Arabic (Algeria)")
    ar_EG = (Language.ar, "Arabic (Egypt)")
    ar_IQ = (Language.ar, "Arabic (Iraq)")
    ar_JO = (Language.ar, "Arabic (Jordan)")
    ar_KW = (Language.ar, "Arabic (Kuwait)")
    ar_LB = (Language.ar, "Arabic (Lebanon)")
    ar_LY = (Language.ar, "Arabic (Libya)")
    ar_MA = (Language.ar, "Arabic (Morocco)")
    ar_OM = (Language.ar, "Arabic (Oman)")
    ar_QA = (Language.ar, "Arabic (Qatar)")
    ar_SA = (Language.ar, "Arabic (Saudi Arabia)")
    ar_SY = (Language.ar, "Arabic (Syria)")
    ar_TN = (Language.ar, "Arabic (Tunisia)")
    ar_XA = (Language.ar, "Arabic")
    ar_YE = (Language.ar, "Arabic (Yemen)")
    
    as_IN = (Language.as_, "Assamese (India)")
    az_AZ = (Language.az, "Azerbaijani (Azerbaijan)")
    ba_RU = (Language.ba, "Bashkir (Russia)")

    bg_BG = (Language.bg, "Bulgarian")
    bn_BD = (Language.bn, "Bangla (Bangladesh)")
    bn_IN = (Language.bn, "Bengali (India)")
    bs_BA = (Language.bs, "Bosnian (Bosnia and Herzegovina)")
    ca_ES = (Language.ca, "Catalan")
    cs_CZ = (Language.cs, "Czech")
    cy_GB = (Language.cy, "Welsh")
    da_DK = (Language.da, "Danish")
    fo_FO = (Language.fo, "Faroese (Faroe Islands)")
    de_AT = (Language.de, "German (Austria)")
    de_CH = (Language.de, "German (Switzerland)")
    de_DE = (Language.de, "German (Germany)")
    el_GR = (Language.el, "Greek")
    en_AU = (Language.en, "English (Australia)")
    en_CA = (Language.en, "English (Canada)")
    en_CB = (Language.en, "English (Carribean)")
    en_GB = (Language.en, "English (UK)")
    en_GB_WLS = (Language.en, "English (Welsh)")
    en_IE = (Language.en, "English (Ireland)")
    en_HK = (Language.en, "English (Hong Kong)")
    en_IN = (Language.en, "English (India)")
    en_KE = (Language.en, "English (Kenya)")
    en_NG = (Language.en, "English (Nigeria)")
    en_US = (Language.en, "English (US)")
    en_NZ = (Language.en, "English (New Zealand)")
    en_PH = (Language.en, "English (Philippines)")
    en_SG = (Language.en, "English (Singapore)")
    en_TZ = (Language.en, "English (Tanzania)")
    en_ZA = (Language.en, "English (South Africa)")
    eo_XX = (Language.eo, "Esperanto")
    # spanish
    es_AR = (Language.es, "Spanish (Argentina)")
    es_BO = (Language.es, "Spanish (Bolivia)")
    es_CL = (Language.es, "Spanish (Chile)")
    es_CO = (Language.es, "Spanish (Colombia)")
    es_CR = (Language.es, "Spanish (Costa Rica)")
    es_CU = (Language.es, "Spanish (Cuba)")
    es_DO = (Language.es, "Spanish (Dominican Republic)")
    es_EC = (Language.es, "Spanish (Ecuador)")
    es_ES = (Language.es, "Spanish (Spain)")
    es_GQ = (Language.es, "Spanish (Equatorial Guinea)")
    es_GT = (Language.es, "Spanish (Guatemala)")
    es_HN = (Language.es, "Spanish (Honduras)")
    es_LA = (Language.es, "Spanish (Latin America)")
    es_MX = (Language.es, "Spanish (Mexico)")
    es_NI = (Language.es, "Spanish (Nicaragua)")
    es_PA = (Language.es, "Spanish (Panama)")
    es_PE = (Language.es, "Spanish (Peru)")
    es_PR = (Language.es, "Spanish (Puerto Rico)")
    es_PY = (Language.es, "Spanish (Paraguay)")
    es_SV = (Language.es, "Spanish (El Salvador)")
    es_US = (Language.es, "Spanish (North America)")
    es_UY = (Language.es, "Spanish (Uruguay)")
    es_VE = (Language.es, "Spanish (Venezuela)")

    et_EE = (Language.et, "Estonian")
    eu = (Language.ba, "Basque (Basque Country)")
    fi_FI = (Language.fi, "Finnish")
    fil_PH = (Language.tl, "Filipino (Philippines)")
    fr_BE = (Language.fr, "French (Belgium)")
    fr_CA = (Language.fr_ca, "French (Canada)")
    fr_CH = (Language.fr, "French (Switzerland)")
    fr_FR = (Language.fr, "French (France)")
    ga_IE = (Language.ga, "Irish (Ireland)")
    gl_ES = (Language.gl, "Galician (Spain)")
    gd_GB = (Language.gd, "Gaelic (UK)")
    gu_IN = (Language.gu, "Gujarati (India)")
    he_IL = (Language.he, "Hebrew (Israel)")
    hi_IN = (Language.hi, "Hindi (India)")
    hr_HR = (Language.hr, "Croatian")
    hu_HU = (Language.hu, "Hungarian")
    hy_AM = (Language.hy, "Armenian (Armenia)")
    id_ID = (Language.id_, "Indonesian")
    is_IS = (Language.is_, "Icelandic")
    it_IT = (Language.it, "Italian")
    ja_JP = (Language.ja, "Japanese")
    jv_ID = (Language.jw, "Javanese (Indonesia)")
    ka_GE = (Language.ka, "Georgian (Georgia)")
    ko_KR = (Language.ko, "Korean")
    kk_KZ = (Language.kk, "Kazakh (Kazakhstan)")
    kn_IN = (Language.kn, "Kannada (India)")
    km_KH = (Language.km, "Khmer (Cambodia)")
    la = (Language.la, "Latin")
    lo_LA = (Language.lo, "Lao (Lao People's Democratic Republic")
    lt_LT = (Language.lt, "Lithuanian")
    lv_LV = (Language.lv, "Latvian")
    mk_MK = (Language.mk, "Macedonian (Macedonia)")
    mn_MN = (Language.mn, "Mongolian (Mongolia)")
    ml_IN = (Language.ml, "Malayalam (India)")
    mr_IN = (Language.mr, "Marathi (India)")
    ms_MY = (Language.ms, "Malay")
    mt_MT = (Language.mt, "Maltese (Malta)")
    my_MM = (Language.my, "Burmese (Myanmar [Burma])")
    nb_NO = (Language.nb, "Norwegian")
    ne_NP = (Language.ne, "Nepali (Nepal)")
    nl_BE = (Language.nl, "Dutch (Belgium)")
    nl_NL = (Language.nl, "Dutch")
    pa_IN = (Language.pa, "Punjabi (India)")
    pl_PL = (Language.pl, "Polish")
    ps_AF = (Language.ps, "Pashto (Afghanistan)")
    pt_BR = (Language.pt_br, "Portuguese (Brazil)")
    pt_PT = (Language.pt_pt, "Portuguese (Portugal)")
    ro_RO = (Language.ro, "Romanian")
    ru_RU = (Language.ru, "Russian")
    si_LK = (Language.si, "Sinhala (Sri Lanka)")
    sk_SK = (Language.sk, "Slovak")
    sl_SI = (Language.sl, "Slovenian")
    so_SO = (Language.so, "Somali (Somalia)")
    sq_AL = (Language.sq, "Albanian (Albania)")
    sr_RS = (Language.sr_cyrl, "Serbian (Serbia)")
    su_ID = (Language.su, "Sundanese (Indonesia)")
    sv_SE = (Language.sv, "Swedish")
    sw_KE = (Language.sw, "Swahili (Kenya)")
    sw_TZ = (Language.sw, "Swahili (Tanzania)")
    ta_MY = (Language.ta, "Tamil (Malaysia)")
    ta_IN = (Language.ta, "Tamil (India)")
    ta_LK = (Language.ta, "Tamil (Sri Lanka)")
    ta_SG = (Language.ta, "Tamil (Singapore)")
    te_IN = (Language.te, "Telugu (India)")
    th_TH = (Language.th, "Thai")
    tr_TR = (Language.tr, "Turkish (Turkey)")
    tt_RU = (Language.tt, "Tatar (Russia)")
    ur_IN = (Language.ur, "Urdu (India)")
    ur_PK = (Language.ur, "Urdu (Pakistan)")
    uk_UA = (Language.uk, "Ukrainian (Ukraine)")
    uz_UZ = (Language.uz, "Uzbek (Uzbekistan)")
    vi_VN = (Language.vi, "Vietnamese")
    zh_CN = (Language.zh_cn, "Chinese (Mandarin, Simplified)")
    zh_HK = (Language.yue, "Chinese (Cantonese, Traditional)")
    zh_TW = (Language.zh_tw, "Chinese (Taiwanese Mandarin)")

    # azure has introduced a bunch of new mandarin locales
    zh_CN_henan = (Language.zh_cn, 'Chinese (Zhongyuan Mandarin Henan, Simplified)')
    zh_CN_liaoning = (Language.zh_cn, 'Chinese (Northeastern Mandarin, Simplified)')
    zh_CN_shaanxi = (Language.zh_cn, 'Chinese (Zhongyuan Mandarin Shaanxi, Simplified)')
    zh_CN_shandong = (Language.zh_cn, 'Chinese (Jilu Mandarin, Simplified)')
    zh_CN_sichuan = (Language.zh_cn, 'Chinese (Southwestern Mandarin, Simplified)')

    fa_IR = (Language.fa, "Persian (Iran)")
    zu_ZA = (Language.zu, "Zulu (South Africa)")

    def __init__(self, lang, audio_lang_name):
        self.lang = lang
        self.audio_lang_name = audio_lang_name    


AudioLanguageDefaults = {
    Language.ar: AudioLanguage.ar_XA,
    Language.bn: AudioLanguage.bn_BD,
    Language.de: AudioLanguage.de_DE,
    Language.en: AudioLanguage.en_US,
    Language.es: AudioLanguage.es_ES,
    Language.fr: AudioLanguage.fr_FR,
    Language.nl: AudioLanguage.nl_NL,
    Language.sw: AudioLanguage.sw_TZ,
    Language.ta: AudioLanguage.ta_IN,
    Language.ur: AudioLanguage.ur_PK,
    Language.zh_cn: AudioLanguage.zh_CN
}

# if only one locale is available, make that the default
language_map_to_audio_language = {}
for audio_language in AudioLanguage:
    if audio_language.lang not in language_map_to_audio_language:
        language_map_to_audio_language[audio_language.lang] = []
    language_map_to_audio_language[audio_language.lang].append(audio_language)
for key, value in language_map_to_audio_language.items():
    if len(value) == 1:
        AudioLanguageDefaults[key] = value[0]

