import * as React from 'react';
import Portal from '@material-ui/core/Portal';
import Snackbar from '@material-ui/core/Snackbar';
import Slide from '@material-ui/core/Slide';
import { default as MuiAlert } from '@material-ui/lab/Alert';
/**
 * Returns a React component for "sliding-in" an alert.
 *
 * @private
 * @param props - component properties
 * @returns React element
 */
function SlideTransition(props) {
    return React.createElement(Slide, Object.assign({}, props, { direction: "up" }));
}
/**
 * React component for rendering an alert.
 */
export class Alert extends React.Component {
    /**
     * Returns a React component for rendering an alert.
     *
     * @param props - component properties
     * @returns React component
     */
    constructor(props) {
        super(props);
        /**
         * Callback invoked upon clicking on an alert.
         *
         * @param event - event object
         */
        this._onClick = (event) => {
            if (this.props.onClick) {
                this.props.onClick(event);
                return;
            }
            this._onClose(event, 'click');
        };
        /**
         * Callback invoked upon closing an alert.
         *
         * @param event - event object
         * @param reason - reason why the callback was invoked
         */
        this._onClose = (event, reason) => {
            if (reason === 'clickaway') {
                return;
            }
            this.props.onClose(event);
        };
    }
    /**
     * Renders the component.
     *
     * @returns React element
     */
    render() {
        let duration = null;
        const severity = this.props.severity || 'info';
        if (severity === 'success') {
            duration = this.props.duration || 5000; // milliseconds
        }
        return (React.createElement(Portal, null,
            React.createElement(Snackbar, { key: "git:alert", open: this.props.open, anchorOrigin: {
                    vertical: 'bottom',
                    horizontal: 'right'
                }, autoHideDuration: duration, TransitionComponent: SlideTransition, onClick: this._onClick, onClose: this._onClose },
                React.createElement(MuiAlert, { variant: "filled", severity: severity }, this.props.message || '(missing message)'))));
    }
}
//# sourceMappingURL=Alert.js.map