import { IRenderMimeRegistry } from '@jupyterlab/rendermime';
import { ISettingRegistry } from '@jupyterlab/settingregistry';
import * as React from 'react';
import { GitExtension } from '../model';
import { Git } from '../tokens';
export declare namespace CommandIDs {
    const gitFileOpen = "git:context-open";
    const gitFileUnstage = "git:context-unstage";
    const gitFileStage = "git:context-stage";
    const gitFileTrack = "git:context-track";
    const gitFileDiscard = "git:context-discard";
    const gitFileDiffWorking = "git:context-diffWorking";
    const gitFileDiffIndex = "git:context-diffIndex";
    const gitIgnore = "git:context-ignore";
    const gitIgnoreExtension = "git:context-ignoreExtension";
}
export interface IFileListState {
    selectedFile: Git.IStatusFile | null;
}
export interface IFileListProps {
    files: Git.IStatusFile[];
    model: GitExtension;
    renderMime: IRenderMimeRegistry;
    settings: ISettingRegistry.ISettings;
}
export declare class FileList extends React.Component<IFileListProps, IFileListState> {
    constructor(props: IFileListProps);
    /** Handle right-click on a staged file */
    contextMenuStaged: (event: React.MouseEvent<Element, MouseEvent>) => void;
    /** Handle right-click on an unstaged file */
    contextMenuUnstaged: (event: React.MouseEvent<Element, MouseEvent>) => void;
    /** Handle right-click on an untracked file */
    contextMenuUntracked: (event: React.MouseEvent<Element, MouseEvent>) => void;
    /** Handle right-click on an untracked file in Simple mode*/
    contextMenuSimpleUntracked: (event: React.MouseEvent<Element, MouseEvent>) => void;
    /** Handle right-click on an tracked file in Simple mode*/
    contextMenuSimpleTracked: (event: React.MouseEvent<Element, MouseEvent>) => void;
    /** Reset all staged files */
    resetAllStagedFiles: () => Promise<void>;
    /** Reset a specific staged file */
    resetStagedFile: (file: string) => Promise<void>;
    /** Add all unstaged files */
    addAllUnstagedFiles: () => Promise<void>;
    /** Discard changes in all unstaged files */
    discardAllUnstagedFiles: () => Promise<void>;
    /** Discard changes in all unstaged and staged files */
    discardAllChanges: () => Promise<void>;
    /** Add a specific unstaged file */
    addFile: (...file: string[]) => Promise<void>;
    /** Discard changes in a specific unstaged or staged file */
    discardChanges: (file: Git.IStatusFile) => Promise<void>;
    /** Add all untracked files */
    addAllUntrackedFiles: () => Promise<void>;
    addAllMarkedFiles: () => Promise<void>;
    updateSelectedFile: (file: Git.IStatusFile) => void;
    get markedFiles(): Git.IStatusFile[];
    render(): JSX.Element;
    private _isSelectedFile;
    private _renderStaged;
    private _renderChanged;
    private _renderUntracked;
    private _renderSimpleStage;
    /**
     * Creates a button element which, depending on the settings, is used
     * to either request a diff of the file, or open the file
     *
     * @param path File path of interest
     * @param currentRef the ref to diff against the git 'HEAD' ref
     */
    private _createDiffButton;
    /**
     * Returns a callback which opens a diff of the file
     *
     * @param file File to open diff for
     * @param currentRef the ref to diff against the git 'HEAD' ref
     */
    private _openDiffView;
    private _contextMenuStaged;
    private _contextMenuUnstaged;
    private _contextMenuUntracked;
    private _contextMenuUntrackedMin;
    private _contextMenuSimpleTracked;
    private _contextMenuSimpleUntracked;
    private _contextMenuSimpleUntrackedMin;
}
