import * as React from 'react';
/**
 * Git stage component properties
 */
export interface IGitStageProps {
    /**
     * Actions component to display at the far right of the stage
     */
    actions: React.ReactElement;
    /**
     * Is this group collapsible
     */
    collapsible?: boolean;
    /**
     * Group title
     */
    heading: string;
    /**
     * Number of files in the group
     */
    nFiles: number;
}
/**
 * Git stage component state
 */
export interface IGitStageState {
    showFiles: boolean;
}
export declare const GitStage: React.FunctionComponent<IGitStageProps>;
