import * as React from 'react';
import { Git, IGitExtension, ILogMessage } from '../tokens';
/**
 * Interface describing component properties.
 */
export interface INewBranchDialogProps {
    /**
     * Git extension data model.
     */
    model: IGitExtension;
    /**
     * Boolean indicating whether to show the dialog.
     */
    open: boolean;
    /**
     * Boolean indicating whether to enable UI suspension.
     */
    suspend: boolean;
    /**
     * Callback to invoke upon closing the dialog.
     */
    onClose: () => void;
}
/**
 * Interface describing component state.
 */
export interface INewBranchDialogState {
    /**
     * Branch name.
     */
    name: string;
    /**
     * Base branch.
     */
    base: string;
    /**
     * Menu filter.
     */
    filter: string;
    /**
     * Current branch name.
     */
    current: string;
    /**
     * Current list of branches.
     */
    branches: Git.IBranch[];
    /**
     * Error message.
     */
    error: string;
    /**
     * Boolean indicating whether UI interaction should be suspended (e.g., due to pending command).
     */
    suspend: boolean;
    /**
     * Boolean indicating whether to show an alert.
     */
    alert: boolean;
    /**
     * Log message.
     */
    log: ILogMessage;
}
/**
 * React component for rendering a dialog to create a new branch.
 */
export declare class NewBranchDialog extends React.Component<INewBranchDialogProps, INewBranchDialogState> {
    /**
     * Returns a React component for rendering a branch menu.
     *
     * @param props - component properties
     * @returns React component
     */
    constructor(props: INewBranchDialogProps);
    /**
     * Callback invoked immediately after mounting a component (i.e., inserting into a tree).
     */
    componentDidMount(): void;
    /**
     * Callback invoked when a component will no longer be mounted.
     */
    componentWillUnmount(): void;
    /**
     * Renders the component.
     *
     * @returns React element
     */
    render(): React.ReactElement;
    /**
     * Renders a dialog for creating a new branch.
     *
     * @returns React element
     */
    private _renderDialog;
    /**
     * Renders branch menu items.
     *
     * @returns array of React elements
     */
    private _renderItems;
    /**
     * Renders a branch menu item.
     *
     * @param branch - branch
     * @param idx - item index
     * @returns React element
     */
    private _renderItem;
    /**
     * Renders a component to provide UI feedback.
     *
     * @returns React element
     */
    private _renderFeedback;
    /**
     * Adds model listeners.
     */
    private _addListeners;
    /**
     * Removes model listeners.
     */
    private _removeListeners;
    /**
     * Syncs the component state with the underlying model.
     */
    private _syncState;
    /**
     * Sets the suspension state.
     *
     * @param bool - boolean indicating whether to suspend UI interaction
     */
    private _suspend;
    /**
     * Sets the current component log message.
     *
     * @param msg - log message
     */
    private _log;
    /**
     * Callback invoked upon closing the dialog.
     *
     * @param event - event object
     */
    private _onClose;
    /**
     * Callback invoked upon a change to the menu filter.
     *
     * @param event - event object
     */
    private _onFilterChange;
    /**
     * Callback invoked to reset the menu filter.
     */
    private _resetFilter;
    /**
     * Returns a callback which is invoked upon clicking a branch name.
     *
     * @param branch - branch name
     * @returns callback
     */
    private _onBranchClickFactory;
    /**
     * Callback invoked upon a change to the branch name input element.
     *
     * @param event - event object
     */
    private _onNameChange;
    /**
     * Callback invoked upon clicking a button to create a new branch.
     *
     * @param event - event object
     */
    private _onCreate;
    /**
     * Creates a new branch.
     *
     * @param branch - branch name
     * @returns promise which resolves upon attempting to create a new branch
     */
    private _createBranch;
    /**
     * Callback invoked upon clicking on the feedback modal.
     *
     * @param event - event object
     */
    private _onFeedbackModalClick;
    /**
     * Callback invoked upon closing a feedback alert.
     *
     * @param event - event object
     */
    private _onFeedbackAlertClose;
}
