import { GitExtension } from './model';
import { Git } from './tokens';
/** Get the filename from a path */
export declare function extractFilename(path: string): string;
export declare function decodeStage(x: string, y: string): Git.Status;
/** Open a file in the git listing */
export declare function openListedFile(file: Git.IStatusFileResult, model: GitExtension): Promise<void>;
/**
 * Get the extension of a given file
 *
 * @param path File path for which the icon should be found
 */
export declare function getFileIconClassName(path: string): string;
/**
 * Returns a promise which resolves after a specified duration.
 *
 * @param ms - duration (in milliseconds)
 * @returns a promise
 */
export declare function sleep(ms: number): Promise<unknown>;
