import { Widget } from '@lumino/widgets';
import { IGitExtension } from '../tokens';
/**
 * The UI for the content shown within the Git push/pull modal.
 */
export declare class GitTagDialog extends Widget {
    /**
     * Instantiates the dialog and makes the relevant service API call.
     */
    constructor(model: IGitExtension);
    /**
     * Call the Git REST API
     */
    private _executeGitApi;
    /**
     * Handles the response from the server by removing the _spinner and showing the appropriate
     * success or error message.
     *
     * @param response the response from the server API call
     */
    private _handleResponse;
    /**
     * Handle failed Git tag REST API call
     *
     * @param message Error message
     */
    private _handleError;
    /**
     * Handle successful Git tag REST API call
     *
     * @param response Git REST API response
     */
    private _handleSuccess;
    /**
     * Create the dialog body node
     */
    private _createBody;
    /**
     * Returns the input value.
     */
    getValue(): string;
    private _body;
    private _list;
    private _model;
    private _spinner;
}
