import logging
import os

from notetool.secret import read_secret
from sqlalchemy import create_engine
from sqlalchemy.orm import declarative_base, sessionmaker

uri = read_secret(cate1='notecoin', cate2='dataset', cate3='db_path')
uri = uri or f'sqlite:///{os.path.abspath(os.path.dirname(__file__))}/data/notecoin.db'
engine = create_engine(uri, echo=True)
Base = declarative_base()
session = sessionmaker(bind=engine)()

logging.info(f'uri:{uri}')

def create_all():
    Base.metadata.create_all(engine)