import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApiIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Explicitly limits external functions that use the integration to reference one or more HTTPS proxy service endpoints and resources within those proxies.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/api_integration#api_allowed_prefixes ApiIntegration#api_allowed_prefixes}
     *
     * @stability stable
     */
    readonly apiAllowedPrefixes: string[];
    /**
     * ARN of a cloud platform role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/api_integration#api_aws_role_arn ApiIntegration#api_aws_role_arn}
     *
     * @stability stable
     */
    readonly apiAwsRoleArn?: string;
    /**
     * Lists the endpoints and resources in the HTTPS proxy service that are not allowed to be called from Snowflake.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/api_integration#api_blocked_prefixes ApiIntegration#api_blocked_prefixes}
     *
     * @stability stable
     */
    readonly apiBlockedPrefixes?: string[];
    /**
     * Specifies the HTTPS proxy service type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/api_integration#api_provider ApiIntegration#api_provider}
     *
     * @stability stable
     */
    readonly apiProvider: string;
    /**
     * The 'Application (client) id' of the Azure AD app for your remote service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/api_integration#azure_ad_application_id ApiIntegration#azure_ad_application_id}
     *
     * @stability stable
     */
    readonly azureAdApplicationId?: string;
    /**
     * Specifies the ID for your Office 365 tenant that all Azure API Management instances belong to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/api_integration#azure_tenant_id ApiIntegration#azure_tenant_id}
     *
     * @stability stable
     */
    readonly azureTenantId?: string;
    /**
     * Specifies whether this API integration is enabled or disabled.
     *
     * If the API integration is disabled, any external function that relies on it will not work.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/api_integration#enabled ApiIntegration#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Specifies the name of the API integration.
     *
     * This name follows the rules for Object Identifiers. The name should be unique among api integrations in your account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/api_integration#name ApiIntegration#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/api_integration snowflake_api_integration}.
 *
 * @stability stable
 */
export declare class ApiIntegration extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/api_integration snowflake_api_integration} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApiIntegrationConfig);
    private _apiAllowedPrefixes?;
    /**
     * @stability stable
     */
    get apiAllowedPrefixes(): string[];
    /**
     * @stability stable
     */
    set apiAllowedPrefixes(value: string[]);
    /**
     * @stability stable
     */
    get apiAllowedPrefixesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get apiAwsExternalId(): string;
    /**
     * @stability stable
     */
    get apiAwsIamUserArn(): string;
    private _apiAwsRoleArn?;
    /**
     * @stability stable
     */
    get apiAwsRoleArn(): string;
    /**
     * @stability stable
     */
    set apiAwsRoleArn(value: string);
    /**
     * @stability stable
     */
    resetApiAwsRoleArn(): void;
    /**
     * @stability stable
     */
    get apiAwsRoleArnInput(): string | undefined;
    private _apiBlockedPrefixes?;
    /**
     * @stability stable
     */
    get apiBlockedPrefixes(): string[];
    /**
     * @stability stable
     */
    set apiBlockedPrefixes(value: string[]);
    /**
     * @stability stable
     */
    resetApiBlockedPrefixes(): void;
    /**
     * @stability stable
     */
    get apiBlockedPrefixesInput(): string[] | undefined;
    private _apiProvider?;
    /**
     * @stability stable
     */
    get apiProvider(): string;
    /**
     * @stability stable
     */
    set apiProvider(value: string);
    /**
     * @stability stable
     */
    get apiProviderInput(): string | undefined;
    private _azureAdApplicationId?;
    /**
     * @stability stable
     */
    get azureAdApplicationId(): string;
    /**
     * @stability stable
     */
    set azureAdApplicationId(value: string);
    /**
     * @stability stable
     */
    resetAzureAdApplicationId(): void;
    /**
     * @stability stable
     */
    get azureAdApplicationIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get azureConsentUrl(): string;
    /**
     * @stability stable
     */
    get azureMultiTenantAppName(): string;
    private _azureTenantId?;
    /**
     * @stability stable
     */
    get azureTenantId(): string;
    /**
     * @stability stable
     */
    set azureTenantId(value: string);
    /**
     * @stability stable
     */
    resetAzureTenantId(): void;
    /**
     * @stability stable
     */
    get azureTenantIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get createdOn(): string;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
