import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataSnowflakeFunctionsConfig extends cdktf.TerraformMetaArguments {
    /**
     * The database from which to return the schemas from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/functions#database DataSnowflakeFunctions#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * The schema from which to return the functions from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/functions#schema DataSnowflakeFunctions#schema}
     *
     * @stability stable
     */
    readonly schema: string;
}
/**
 * @stability stable
 */
export declare class DataSnowflakeFunctionsFunctions extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get argumentTypes(): string[];
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get returnType(): string;
    /**
     * @stability stable
     */
    get schema(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/functions snowflake_functions}.
 *
 * @stability stable
 */
export declare class DataSnowflakeFunctions extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/functions snowflake_functions} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataSnowflakeFunctionsConfig);
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    /**
     * @stability stable
     */
    functions(index: string): DataSnowflakeFunctionsFunctions;
    /**
     * @stability stable
     */
    get id(): string;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
