import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataSnowflakeProceduresConfig extends cdktf.TerraformMetaArguments {
    /**
     * The database from which to return the schemas from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/procedures#database DataSnowflakeProcedures#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * The schema from which to return the procedures from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/procedures#schema DataSnowflakeProcedures#schema}
     *
     * @stability stable
     */
    readonly schema: string;
}
/**
 * @stability stable
 */
export declare class DataSnowflakeProceduresProcedures extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get argumentTypes(): string[];
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get returnType(): string;
    /**
     * @stability stable
     */
    get schema(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/procedures snowflake_procedures}.
 *
 * @stability stable
 */
export declare class DataSnowflakeProcedures extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/procedures snowflake_procedures} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataSnowflakeProceduresConfig);
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    procedures(index: string): DataSnowflakeProceduresProcedures;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
