import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataSnowflakeSchemasConfig extends cdktf.TerraformMetaArguments {
    /**
     * The database from which to return the schemas from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/schemas#database DataSnowflakeSchemas#database}
     *
     * @stability stable
     */
    readonly database: string;
}
/**
 * @stability stable
 */
export declare class DataSnowflakeSchemasSchemas extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/schemas snowflake_schemas}.
 *
 * @stability stable
 */
export declare class DataSnowflakeSchemas extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/schemas snowflake_schemas} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataSnowflakeSchemasConfig);
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    schemas(index: string): DataSnowflakeSchemasSchemas;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
