import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataSnowflakeStagesConfig extends cdktf.TerraformMetaArguments {
    /**
     * The database from which to return the schemas from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/stages#database DataSnowflakeStages#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * The schema from which to return the stages from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/stages#schema DataSnowflakeStages#schema}
     *
     * @stability stable
     */
    readonly schema: string;
}
/**
 * @stability stable
 */
export declare class DataSnowflakeStagesStages extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    get storageIntegration(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/stages snowflake_stages}.
 *
 * @stability stable
 */
export declare class DataSnowflakeStages extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/stages snowflake_stages} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataSnowflakeStagesConfig);
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    /**
     * @stability stable
     */
    stages(index: string): DataSnowflakeStagesStages;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
