import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataSnowflakeSystemGenerateScimAccessTokenConfig extends cdktf.TerraformMetaArguments {
    /**
     * SCIM Integration Name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/system_generate_scim_access_token#integration_name DataSnowflakeSystemGenerateScimAccessToken#integration_name}
     *
     * @stability stable
     */
    readonly integrationName: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/system_generate_scim_access_token snowflake_system_generate_scim_access_token}.
 *
 * @stability stable
 */
export declare class DataSnowflakeSystemGenerateScimAccessToken extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/system_generate_scim_access_token snowflake_system_generate_scim_access_token} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataSnowflakeSystemGenerateScimAccessTokenConfig);
    /**
     * @stability stable
     */
    get accessToken(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _integrationName?;
    /**
     * @stability stable
     */
    get integrationName(): string;
    /**
     * @stability stable
     */
    set integrationName(value: string);
    /**
     * @stability stable
     */
    get integrationNameInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
