import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataSnowflakeSystemGetAwsSnsIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Amazon Resource Name (ARN) of the SNS topic for your S3 bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/system_get_aws_sns_iam_policy#aws_sns_topic_arn DataSnowflakeSystemGetAwsSnsIamPolicy#aws_sns_topic_arn}
     *
     * @stability stable
     */
    readonly awsSnsTopicArn: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/system_get_aws_sns_iam_policy snowflake_system_get_aws_sns_iam_policy}.
 *
 * @stability stable
 */
export declare class DataSnowflakeSystemGetAwsSnsIamPolicy extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/system_get_aws_sns_iam_policy snowflake_system_get_aws_sns_iam_policy} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataSnowflakeSystemGetAwsSnsIamPolicyConfig);
    private _awsSnsTopicArn?;
    /**
     * @stability stable
     */
    get awsSnsTopicArn(): string;
    /**
     * @stability stable
     */
    set awsSnsTopicArn(value: string);
    /**
     * @stability stable
     */
    get awsSnsTopicArnInput(): string | undefined;
    /**
     * @stability stable
     */
    get awsSnsTopicPolicyJson(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
