import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataSnowflakeTasksConfig extends cdktf.TerraformMetaArguments {
    /**
     * The database from which to return the schemas from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/tasks#database DataSnowflakeTasks#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * The schema from which to return the tasks from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/tasks#schema DataSnowflakeTasks#schema}
     *
     * @stability stable
     */
    readonly schema: string;
}
/**
 * @stability stable
 */
export declare class DataSnowflakeTasksTasks extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    get warehouse(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/tasks snowflake_tasks}.
 *
 * @stability stable
 */
export declare class DataSnowflakeTasks extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/tasks snowflake_tasks} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataSnowflakeTasksConfig);
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    /**
     * @stability stable
     */
    tasks(index: string): DataSnowflakeTasksTasks;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
