import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DatabaseGrantConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the database on which to grant privileges.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database_grant#database_name DatabaseGrant#database_name}
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * The privilege to grant on the database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database_grant#privilege DatabaseGrant#privilege}
     *
     * @stability stable
     */
    readonly privilege?: string;
    /**
     * Grants privilege to these roles.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database_grant#roles DatabaseGrant#roles}
     *
     * @stability stable
     */
    readonly roles?: string[];
    /**
     * Grants privilege to these shares.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database_grant#shares DatabaseGrant#shares}
     *
     * @stability stable
     */
    readonly shares?: string[];
    /**
     * When this is set to true, allows the recipient role to grant the privileges to other roles.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database_grant#with_grant_option DatabaseGrant#with_grant_option}
     *
     * @stability stable
     */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/database_grant snowflake_database_grant}.
 *
 * @stability stable
 */
export declare class DatabaseGrant extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/database_grant snowflake_database_grant} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DatabaseGrantConfig);
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _privilege?;
    /**
     * @stability stable
     */
    get privilege(): string;
    /**
     * @stability stable
     */
    set privilege(value: string);
    /**
     * @stability stable
     */
    resetPrivilege(): void;
    /**
     * @stability stable
     */
    get privilegeInput(): string | undefined;
    private _roles?;
    /**
     * @stability stable
     */
    get roles(): string[];
    /**
     * @stability stable
     */
    set roles(value: string[]);
    /**
     * @stability stable
     */
    resetRoles(): void;
    /**
     * @stability stable
     */
    get rolesInput(): string[] | undefined;
    private _shares?;
    /**
     * @stability stable
     */
    get shares(): string[];
    /**
     * @stability stable
     */
    set shares(value: string[]);
    /**
     * @stability stable
     */
    resetShares(): void;
    /**
     * @stability stable
     */
    get sharesInput(): string[] | undefined;
    private _withGrantOption?;
    /**
     * @stability stable
     */
    get withGrantOption(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set withGrantOption(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWithGrantOption(): void;
    /**
     * @stability stable
     */
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
