import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#comment Database#comment}.
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#data_retention_time_in_days Database#data_retention_time_in_days}.
     *
     * @stability stable
     */
    readonly dataRetentionTimeInDays?: number;
    /**
     * Specify a database to create a clone from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#from_database Database#from_database}
     *
     * @stability stable
     */
    readonly fromDatabase?: string;
    /**
     * Specify a provider and a share in this map to create a database from a share.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#from_share Database#from_share}
     *
     * @stability stable
     */
    readonly fromShare?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#name Database#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * tag block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#tag Database#tag}
     *
     * @stability stable
     */
    readonly tag?: DatabaseTag[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface DatabaseTag {
    /**
     * Name of the database that the tag was created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#database Database#database}
     *
     * @stability stable
     */
    readonly database?: string;
    /**
     * Tag name, e.g. department.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#name Database#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of the schema that the tag was created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#schema Database#schema}
     *
     * @stability stable
     */
    readonly schema?: string;
    /**
     * Tag value, e.g. marketing_info.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#value Database#value}
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function databaseTagToTerraform(struct?: DatabaseTag | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/database snowflake_database}.
 *
 * @stability stable
 */
export declare class Database extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/database snowflake_database} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DatabaseConfig);
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    private _dataRetentionTimeInDays?;
    /**
     * @stability stable
     */
    get dataRetentionTimeInDays(): number;
    /**
     * @stability stable
     */
    set dataRetentionTimeInDays(value: number);
    /**
     * @stability stable
     */
    resetDataRetentionTimeInDays(): void;
    /**
     * @stability stable
     */
    get dataRetentionTimeInDaysInput(): number | undefined;
    private _fromDatabase?;
    /**
     * @stability stable
     */
    get fromDatabase(): string;
    /**
     * @stability stable
     */
    set fromDatabase(value: string);
    /**
     * @stability stable
     */
    resetFromDatabase(): void;
    /**
     * @stability stable
     */
    get fromDatabaseInput(): string | undefined;
    private _fromShare?;
    /**
     * @stability stable
     */
    get fromShare(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set fromShare(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetFromShare(): void;
    /**
     * @stability stable
     */
    get fromShareInput(): {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): DatabaseTag[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tag(value: DatabaseTag[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): cdktf.IResolvable | DatabaseTag[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
