import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ExternalFunctionConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the API integration object that should be used to authenticate the call to the proxy service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#api_integration ExternalFunction#api_integration}
     *
     * @stability stable
     */
    readonly apiIntegration: string;
    /**
     * A description of the external function.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#comment ExternalFunction#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * If specified, the JSON payload is compressed when sent from Snowflake to the proxy service, and when sent back from the proxy service to Snowflake.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#compression ExternalFunction#compression}
     *
     * @stability stable
     */
    readonly compression?: string;
    /**
     * Binds Snowflake context function results to HTTP headers.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#context_headers ExternalFunction#context_headers}
     *
     * @stability stable
     */
    readonly contextHeaders?: string[];
    /**
     * The database in which to create the external function.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#database ExternalFunction#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * This specifies the maximum number of rows in each batch sent to the proxy service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#max_batch_rows ExternalFunction#max_batch_rows}
     *
     * @stability stable
     */
    readonly maxBatchRows?: number;
    /**
     * Specifies the identifier for the external function.
     *
     * The identifier can contain the schema name and database name, as well as the function name. The function's signature (name and argument data types) must be unique within the schema.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#name ExternalFunction#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Specifies the behavior of the external function when called with null inputs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#null_input_behavior ExternalFunction#null_input_behavior}
     *
     * @stability stable
     */
    readonly nullInputBehavior?: string;
    /**
     * Specifies the behavior of the function when returning results.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#return_behavior ExternalFunction#return_behavior}
     *
     * @stability stable
     */
    readonly returnBehavior: string;
    /**
     * Indicates whether the function can return NULL values or must return only NON-NULL values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#return_null_allowed ExternalFunction#return_null_allowed}
     *
     * @stability stable
     */
    readonly returnNullAllowed?: boolean | cdktf.IResolvable;
    /**
     * Specifies the data type returned by the external function.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#return_type ExternalFunction#return_type}
     *
     * @stability stable
     */
    readonly returnType: string;
    /**
     * The schema in which to create the external function.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#schema ExternalFunction#schema}
     *
     * @stability stable
     */
    readonly schema: string;
    /**
     * This is the invocation URL of the proxy service and resource through which Snowflake calls the remote service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#url_of_proxy_and_resource ExternalFunction#url_of_proxy_and_resource}
     *
     * @stability stable
     */
    readonly urlOfProxyAndResource: string;
    /**
     * arg block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#arg ExternalFunction#arg}
     *
     * @stability stable
     */
    readonly arg?: ExternalFunctionArg[] | cdktf.IResolvable;
    /**
     * header block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#header ExternalFunction#header}
     *
     * @stability stable
     */
    readonly header?: ExternalFunctionHeader[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface ExternalFunctionArg {
    /**
     * Argument name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#name ExternalFunction#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Argument type, e.g. VARCHAR.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#type ExternalFunction#type}
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function externalFunctionArgToTerraform(struct?: ExternalFunctionArg | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ExternalFunctionHeader {
    /**
     * Header name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#name ExternalFunction#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Header value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#value ExternalFunction#value}
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function externalFunctionHeaderToTerraform(struct?: ExternalFunctionHeader | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/external_function snowflake_external_function}.
 *
 * @stability stable
 */
export declare class ExternalFunction extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/external_function snowflake_external_function} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ExternalFunctionConfig);
    private _apiIntegration?;
    /**
     * @stability stable
     */
    get apiIntegration(): string;
    /**
     * @stability stable
     */
    set apiIntegration(value: string);
    /**
     * @stability stable
     */
    get apiIntegrationInput(): string | undefined;
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    private _compression?;
    /**
     * @stability stable
     */
    get compression(): string;
    /**
     * @stability stable
     */
    set compression(value: string);
    /**
     * @stability stable
     */
    resetCompression(): void;
    /**
     * @stability stable
     */
    get compressionInput(): string | undefined;
    private _contextHeaders?;
    /**
     * @stability stable
     */
    get contextHeaders(): string[];
    /**
     * @stability stable
     */
    set contextHeaders(value: string[]);
    /**
     * @stability stable
     */
    resetContextHeaders(): void;
    /**
     * @stability stable
     */
    get contextHeadersInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get createdOn(): string;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _maxBatchRows?;
    /**
     * @stability stable
     */
    get maxBatchRows(): number;
    /**
     * @stability stable
     */
    set maxBatchRows(value: number);
    /**
     * @stability stable
     */
    resetMaxBatchRows(): void;
    /**
     * @stability stable
     */
    get maxBatchRowsInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nullInputBehavior?;
    /**
     * @stability stable
     */
    get nullInputBehavior(): string;
    /**
     * @stability stable
     */
    set nullInputBehavior(value: string);
    /**
     * @stability stable
     */
    resetNullInputBehavior(): void;
    /**
     * @stability stable
     */
    get nullInputBehaviorInput(): string | undefined;
    private _returnBehavior?;
    /**
     * @stability stable
     */
    get returnBehavior(): string;
    /**
     * @stability stable
     */
    set returnBehavior(value: string);
    /**
     * @stability stable
     */
    get returnBehaviorInput(): string | undefined;
    private _returnNullAllowed?;
    /**
     * @stability stable
     */
    get returnNullAllowed(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set returnNullAllowed(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReturnNullAllowed(): void;
    /**
     * @stability stable
     */
    get returnNullAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _returnType?;
    /**
     * @stability stable
     */
    get returnType(): string;
    /**
     * @stability stable
     */
    set returnType(value: string);
    /**
     * @stability stable
     */
    get returnTypeInput(): string | undefined;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    private _urlOfProxyAndResource?;
    /**
     * @stability stable
     */
    get urlOfProxyAndResource(): string;
    /**
     * @stability stable
     */
    set urlOfProxyAndResource(value: string);
    /**
     * @stability stable
     */
    get urlOfProxyAndResourceInput(): string | undefined;
    private _arg?;
    /**
     * @stability stable
     */
    get arg(): ExternalFunctionArg[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set arg(value: ExternalFunctionArg[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetArg(): void;
    /**
     * @stability stable
     */
    get argInput(): cdktf.IResolvable | ExternalFunctionArg[] | undefined;
    private _header?;
    /**
     * @stability stable
     */
    get header(): ExternalFunctionHeader[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set header(value: ExternalFunctionHeader[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHeader(): void;
    /**
     * @stability stable
     */
    get headerInput(): cdktf.IResolvable | ExternalFunctionHeader[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
