import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ExternalTableGrantConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the database containing the current or future external tables on which to grant privileges.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table_grant#database_name ExternalTableGrant#database_name}
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * The name of the external table on which to grant privileges immediately (only valid if on_future is false).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table_grant#external_table_name ExternalTableGrant#external_table_name}
     *
     * @stability stable
     */
    readonly externalTableName?: string;
    /**
     * When this is set to true and a schema_name is provided, apply this grant on all future external tables in the given schema.
     *
     * When this is true and no schema_name is provided apply this grant on all future external tables in the given database. The external_table_name and shares fields must be unset in order to use on_future.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table_grant#on_future ExternalTableGrant#on_future}
     *
     * @stability stable
     */
    readonly onFuture?: boolean | cdktf.IResolvable;
    /**
     * The privilege to grant on the current or future external table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table_grant#privilege ExternalTableGrant#privilege}
     *
     * @stability stable
     */
    readonly privilege?: string;
    /**
     * Grants privilege to these roles.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table_grant#roles ExternalTableGrant#roles}
     *
     * @stability stable
     */
    readonly roles?: string[];
    /**
     * The name of the schema containing the current or future external tables on which to grant privileges.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table_grant#schema_name ExternalTableGrant#schema_name}
     *
     * @stability stable
     */
    readonly schemaName: string;
    /**
     * Grants privilege to these shares (only valid if on_future is false).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table_grant#shares ExternalTableGrant#shares}
     *
     * @stability stable
     */
    readonly shares?: string[];
    /**
     * When this is set to true, allows the recipient role to grant the privileges to other roles.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table_grant#with_grant_option ExternalTableGrant#with_grant_option}
     *
     * @stability stable
     */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/external_table_grant snowflake_external_table_grant}.
 *
 * @stability stable
 */
export declare class ExternalTableGrant extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/external_table_grant snowflake_external_table_grant} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ExternalTableGrantConfig);
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _externalTableName?;
    /**
     * @stability stable
     */
    get externalTableName(): string;
    /**
     * @stability stable
     */
    set externalTableName(value: string);
    /**
     * @stability stable
     */
    resetExternalTableName(): void;
    /**
     * @stability stable
     */
    get externalTableNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _onFuture?;
    /**
     * @stability stable
     */
    get onFuture(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set onFuture(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOnFuture(): void;
    /**
     * @stability stable
     */
    get onFutureInput(): boolean | cdktf.IResolvable | undefined;
    private _privilege?;
    /**
     * @stability stable
     */
    get privilege(): string;
    /**
     * @stability stable
     */
    set privilege(value: string);
    /**
     * @stability stable
     */
    resetPrivilege(): void;
    /**
     * @stability stable
     */
    get privilegeInput(): string | undefined;
    private _roles?;
    /**
     * @stability stable
     */
    get roles(): string[];
    /**
     * @stability stable
     */
    set roles(value: string[]);
    /**
     * @stability stable
     */
    resetRoles(): void;
    /**
     * @stability stable
     */
    get rolesInput(): string[] | undefined;
    private _schemaName?;
    /**
     * @stability stable
     */
    get schemaName(): string;
    /**
     * @stability stable
     */
    set schemaName(value: string);
    /**
     * @stability stable
     */
    get schemaNameInput(): string | undefined;
    private _shares?;
    /**
     * @stability stable
     */
    get shares(): string[];
    /**
     * @stability stable
     */
    set shares(value: string[]);
    /**
     * @stability stable
     */
    resetShares(): void;
    /**
     * @stability stable
     */
    get sharesInput(): string[] | undefined;
    private _withGrantOption?;
    /**
     * @stability stable
     */
    get withGrantOption(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set withGrantOption(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWithGrantOption(): void;
    /**
     * @stability stable
     */
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
