import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ExternalTableConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies whether to automatically refresh the external table metadata once, immediately after the external table is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#auto_refresh ExternalTable#auto_refresh}
     *
     * @stability stable
     */
    readonly autoRefresh?: boolean | cdktf.IResolvable;
    /**
     * Specifies the aws sns topic for the external table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#aws_sns_topic ExternalTable#aws_sns_topic}
     *
     * @stability stable
     */
    readonly awsSnsTopic?: string;
    /**
     * Specifies a comment for the external table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#comment ExternalTable#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * Specifies to retain the access permissions from the original table when an external table is recreated using the CREATE OR REPLACE TABLE variant.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#copy_grants ExternalTable#copy_grants}
     *
     * @stability stable
     */
    readonly copyGrants?: boolean | cdktf.IResolvable;
    /**
     * The database in which to create the external table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#database ExternalTable#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * Specifies the file format for the external table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#file_format ExternalTable#file_format}
     *
     * @stability stable
     */
    readonly fileFormat: string;
    /**
     * Specifies a location for the external table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#location ExternalTable#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Specifies the identifier for the external table;
     *
     * must be unique for the database and schema in which the externalTable is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#name ExternalTable#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Specifies any partition columns to evaluate for the external table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#partition_by ExternalTable#partition_by}
     *
     * @stability stable
     */
    readonly partitionBy?: string[];
    /**
     * Specifies the file names and/or paths on the external stage to match.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#pattern ExternalTable#pattern}
     *
     * @stability stable
     */
    readonly pattern?: string;
    /**
     * Specifies weather to refresh when an external table is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#refresh_on_create ExternalTable#refresh_on_create}
     *
     * @stability stable
     */
    readonly refreshOnCreate?: boolean | cdktf.IResolvable;
    /**
     * The schema in which to create the external table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#schema ExternalTable#schema}
     *
     * @stability stable
     */
    readonly schema: string;
    /**
     * column block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#column ExternalTable#column}
     *
     * @stability stable
     */
    readonly column: ExternalTableColumn[] | cdktf.IResolvable;
    /**
     * tag block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#tag ExternalTable#tag}
     *
     * @stability stable
     */
    readonly tag?: ExternalTableTag[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface ExternalTableColumn {
    /**
     * String that specifies the expression for the column. When queried, the column returns results derived from this expression.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#as ExternalTable#as}
     *
     * @stability stable
     */
    readonly as: string;
    /**
     * Column name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#name ExternalTable#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Column type, e.g. VARIANT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#type ExternalTable#type}
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function externalTableColumnToTerraform(struct?: ExternalTableColumn | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ExternalTableTag {
    /**
     * Name of the database that the tag was created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#database ExternalTable#database}
     *
     * @stability stable
     */
    readonly database?: string;
    /**
     * Tag name, e.g. department.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#name ExternalTable#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of the schema that the tag was created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#schema ExternalTable#schema}
     *
     * @stability stable
     */
    readonly schema?: string;
    /**
     * Tag value, e.g. marketing_info.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_table#value ExternalTable#value}
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function externalTableTagToTerraform(struct?: ExternalTableTag | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/external_table snowflake_external_table}.
 *
 * @stability stable
 */
export declare class ExternalTable extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/external_table snowflake_external_table} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ExternalTableConfig);
    private _autoRefresh?;
    /**
     * @stability stable
     */
    get autoRefresh(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoRefresh(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoRefresh(): void;
    /**
     * @stability stable
     */
    get autoRefreshInput(): boolean | cdktf.IResolvable | undefined;
    private _awsSnsTopic?;
    /**
     * @stability stable
     */
    get awsSnsTopic(): string;
    /**
     * @stability stable
     */
    set awsSnsTopic(value: string);
    /**
     * @stability stable
     */
    resetAwsSnsTopic(): void;
    /**
     * @stability stable
     */
    get awsSnsTopicInput(): string | undefined;
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    private _copyGrants?;
    /**
     * @stability stable
     */
    get copyGrants(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set copyGrants(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCopyGrants(): void;
    /**
     * @stability stable
     */
    get copyGrantsInput(): boolean | cdktf.IResolvable | undefined;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    private _fileFormat?;
    /**
     * @stability stable
     */
    get fileFormat(): string;
    /**
     * @stability stable
     */
    set fileFormat(value: string);
    /**
     * @stability stable
     */
    get fileFormatInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get owner(): string;
    private _partitionBy?;
    /**
     * @stability stable
     */
    get partitionBy(): string[];
    /**
     * @stability stable
     */
    set partitionBy(value: string[]);
    /**
     * @stability stable
     */
    resetPartitionBy(): void;
    /**
     * @stability stable
     */
    get partitionByInput(): string[] | undefined;
    private _pattern?;
    /**
     * @stability stable
     */
    get pattern(): string;
    /**
     * @stability stable
     */
    set pattern(value: string);
    /**
     * @stability stable
     */
    resetPattern(): void;
    /**
     * @stability stable
     */
    get patternInput(): string | undefined;
    private _refreshOnCreate?;
    /**
     * @stability stable
     */
    get refreshOnCreate(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set refreshOnCreate(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRefreshOnCreate(): void;
    /**
     * @stability stable
     */
    get refreshOnCreateInput(): boolean | cdktf.IResolvable | undefined;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    private _column?;
    /**
     * @stability stable
     */
    get column(): ExternalTableColumn[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set column(value: ExternalTableColumn[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get columnInput(): cdktf.IResolvable | ExternalTableColumn[] | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): ExternalTableTag[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tag(value: ExternalTableTag[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): cdktf.IResolvable | ExternalTableTag[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
