import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FileFormatConfig extends cdktf.TerraformMetaArguments {
    /**
     * Boolean that specifies to allow duplicate object field names (only the last one will be preserved).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#allow_duplicate FileFormat#allow_duplicate}
     *
     * @stability stable
     */
    readonly allowDuplicate?: boolean | cdktf.IResolvable;
    /**
     * Boolean that specifies whether to interpret columns with no defined logical data type as UTF-8 text.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#binary_as_text FileFormat#binary_as_text}
     *
     * @stability stable
     */
    readonly binaryAsText?: boolean | cdktf.IResolvable;
    /**
     * Defines the encoding format for binary input or output.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#binary_format FileFormat#binary_format}
     *
     * @stability stable
     */
    readonly binaryFormat?: string;
    /**
     * Specifies a comment for the file format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#comment FileFormat#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * Specifies the current compression algorithm for the data file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#compression FileFormat#compression}
     *
     * @stability stable
     */
    readonly compression?: string;
    /**
     * The database in which to create the file format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#database FileFormat#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * Defines the format of date values in the data files (data loading) or table (data unloading).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#date_format FileFormat#date_format}
     *
     * @stability stable
     */
    readonly dateFormat?: string;
    /**
     * Boolean that specifies whether the XML parser disables automatic conversion of numeric and Boolean values from text to native representation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#disable_auto_convert FileFormat#disable_auto_convert}
     *
     * @stability stable
     */
    readonly disableAutoConvert?: boolean | cdktf.IResolvable;
    /**
     * Boolean that specifies whether the XML parser disables recognition of Snowflake semi-structured data tags.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#disable_snowflake_data FileFormat#disable_snowflake_data}
     *
     * @stability stable
     */
    readonly disableSnowflakeData?: boolean | cdktf.IResolvable;
    /**
     * Specifies whether to insert SQL NULL for empty fields in an input file, which are represented by two successive delimiters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#empty_field_as_null FileFormat#empty_field_as_null}
     *
     * @stability stable
     */
    readonly emptyFieldAsNull?: boolean | cdktf.IResolvable;
    /**
     * Boolean that enables parsing of octal numbers.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#enable_octal FileFormat#enable_octal}
     *
     * @stability stable
     */
    readonly enableOctal?: boolean | cdktf.IResolvable;
    /**
     * String (constant) that specifies the character set of the source data when loading data into a table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#encoding FileFormat#encoding}
     *
     * @stability stable
     */
    readonly encoding?: string;
    /**
     * Boolean that specifies whether to generate a parsing error if the number of delimited columns (i.e. fields) in an input file does not match the number of columns in the corresponding table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#error_on_column_count_mismatch FileFormat#error_on_column_count_mismatch}
     *
     * @stability stable
     */
    readonly errorOnColumnCountMismatch?: boolean | cdktf.IResolvable;
    /**
     * Single character string used as the escape character for field values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#escape FileFormat#escape}
     *
     * @stability stable
     */
    readonly escape?: string;
    /**
     * Single character string used as the escape character for unenclosed field values only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#escape_unenclosed_field FileFormat#escape_unenclosed_field}
     *
     * @stability stable
     */
    readonly escapeUnenclosedField?: string;
    /**
     * Specifies one or more singlebyte or multibyte characters that separate fields in an input file (data loading) or unloaded file (data unloading).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#field_delimiter FileFormat#field_delimiter}
     *
     * @stability stable
     */
    readonly fieldDelimiter?: string;
    /**
     * Character used to enclose strings.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#field_optionally_enclosed_by FileFormat#field_optionally_enclosed_by}
     *
     * @stability stable
     */
    readonly fieldOptionallyEnclosedBy?: string;
    /**
     * Specifies the extension for files unloaded to a stage.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#file_extension FileFormat#file_extension}
     *
     * @stability stable
     */
    readonly fileExtension?: string;
    /**
     * Specifies the format of the input files (for data loading) or output files (for data unloading).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#format_type FileFormat#format_type}
     *
     * @stability stable
     */
    readonly formatType: string;
    /**
     * Boolean that specifies whether UTF-8 encoding errors produce error conditions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#ignore_utf8_errors FileFormat#ignore_utf8_errors}
     *
     * @stability stable
     */
    readonly ignoreUtf8Errors?: boolean | cdktf.IResolvable;
    /**
     * Specifies the identifier for the file format;
     *
     * must be unique for the database and schema in which the file format is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#name FileFormat#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * String used to convert to and from SQL NULL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#null_if FileFormat#null_if}
     *
     * @stability stable
     */
    readonly nullIf?: string[];
    /**
     * Boolean that specifies whether the XML parser preserves leading and trailing spaces in element content.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#preserve_space FileFormat#preserve_space}
     *
     * @stability stable
     */
    readonly preserveSpace?: boolean | cdktf.IResolvable;
    /**
     * Specifies one or more singlebyte or multibyte characters that separate records in an input file (data loading) or unloaded file (data unloading).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#record_delimiter FileFormat#record_delimiter}
     *
     * @stability stable
     */
    readonly recordDelimiter?: string;
    /**
     * Boolean that specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#replace_invalid_characters FileFormat#replace_invalid_characters}
     *
     * @stability stable
     */
    readonly replaceInvalidCharacters?: boolean | cdktf.IResolvable;
    /**
     * The schema in which to create the file format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#schema FileFormat#schema}
     *
     * @stability stable
     */
    readonly schema: string;
    /**
     * Boolean that specifies to skip any blank lines encountered in the data files.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#skip_blank_lines FileFormat#skip_blank_lines}
     *
     * @stability stable
     */
    readonly skipBlankLines?: boolean | cdktf.IResolvable;
    /**
     * Boolean that specifies whether to skip the BOM (byte order mark), if present in a data file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#skip_byte_order_mark FileFormat#skip_byte_order_mark}
     *
     * @stability stable
     */
    readonly skipByteOrderMark?: boolean | cdktf.IResolvable;
    /**
     * Number of lines at the start of the file to skip.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#skip_header FileFormat#skip_header}
     *
     * @stability stable
     */
    readonly skipHeader?: number;
    /**
     * Boolean that instructs the JSON parser to remove object fields or array elements containing null values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#strip_null_values FileFormat#strip_null_values}
     *
     * @stability stable
     */
    readonly stripNullValues?: boolean | cdktf.IResolvable;
    /**
     * Boolean that instructs the JSON parser to remove outer brackets.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#strip_outer_array FileFormat#strip_outer_array}
     *
     * @stability stable
     */
    readonly stripOuterArray?: boolean | cdktf.IResolvable;
    /**
     * Boolean that specifies whether the XML parser strips out the outer XML element, exposing 2nd level elements as separate documents.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#strip_outer_element FileFormat#strip_outer_element}
     *
     * @stability stable
     */
    readonly stripOuterElement?: boolean | cdktf.IResolvable;
    /**
     * Defines the format of time values in the data files (data loading) or table (data unloading).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#time_format FileFormat#time_format}
     *
     * @stability stable
     */
    readonly timeFormat?: string;
    /**
     * Defines the format of timestamp values in the data files (data loading) or table (data unloading).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#timestamp_format FileFormat#timestamp_format}
     *
     * @stability stable
     */
    readonly timestampFormat?: string;
    /**
     * Boolean that specifies whether to remove white space from fields.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#trim_space FileFormat#trim_space}
     *
     * @stability stable
     */
    readonly trimSpace?: boolean | cdktf.IResolvable;
    /**
     * Boolean that specifies whether to validate UTF-8 character encoding in string column data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#validate_utf8 FileFormat#validate_utf8}
     *
     * @stability stable
     */
    readonly validateUtf8?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/file_format snowflake_file_format}.
 *
 * @stability stable
 */
export declare class FileFormat extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/file_format snowflake_file_format} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FileFormatConfig);
    private _allowDuplicate?;
    /**
     * @stability stable
     */
    get allowDuplicate(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowDuplicate(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowDuplicate(): void;
    /**
     * @stability stable
     */
    get allowDuplicateInput(): boolean | cdktf.IResolvable | undefined;
    private _binaryAsText?;
    /**
     * @stability stable
     */
    get binaryAsText(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set binaryAsText(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetBinaryAsText(): void;
    /**
     * @stability stable
     */
    get binaryAsTextInput(): boolean | cdktf.IResolvable | undefined;
    private _binaryFormat?;
    /**
     * @stability stable
     */
    get binaryFormat(): string;
    /**
     * @stability stable
     */
    set binaryFormat(value: string);
    /**
     * @stability stable
     */
    resetBinaryFormat(): void;
    /**
     * @stability stable
     */
    get binaryFormatInput(): string | undefined;
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    private _compression?;
    /**
     * @stability stable
     */
    get compression(): string;
    /**
     * @stability stable
     */
    set compression(value: string);
    /**
     * @stability stable
     */
    resetCompression(): void;
    /**
     * @stability stable
     */
    get compressionInput(): string | undefined;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    private _dateFormat?;
    /**
     * @stability stable
     */
    get dateFormat(): string;
    /**
     * @stability stable
     */
    set dateFormat(value: string);
    /**
     * @stability stable
     */
    resetDateFormat(): void;
    /**
     * @stability stable
     */
    get dateFormatInput(): string | undefined;
    private _disableAutoConvert?;
    /**
     * @stability stable
     */
    get disableAutoConvert(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disableAutoConvert(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisableAutoConvert(): void;
    /**
     * @stability stable
     */
    get disableAutoConvertInput(): boolean | cdktf.IResolvable | undefined;
    private _disableSnowflakeData?;
    /**
     * @stability stable
     */
    get disableSnowflakeData(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disableSnowflakeData(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisableSnowflakeData(): void;
    /**
     * @stability stable
     */
    get disableSnowflakeDataInput(): boolean | cdktf.IResolvable | undefined;
    private _emptyFieldAsNull?;
    /**
     * @stability stable
     */
    get emptyFieldAsNull(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set emptyFieldAsNull(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEmptyFieldAsNull(): void;
    /**
     * @stability stable
     */
    get emptyFieldAsNullInput(): boolean | cdktf.IResolvable | undefined;
    private _enableOctal?;
    /**
     * @stability stable
     */
    get enableOctal(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableOctal(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableOctal(): void;
    /**
     * @stability stable
     */
    get enableOctalInput(): boolean | cdktf.IResolvable | undefined;
    private _encoding?;
    /**
     * @stability stable
     */
    get encoding(): string;
    /**
     * @stability stable
     */
    set encoding(value: string);
    /**
     * @stability stable
     */
    resetEncoding(): void;
    /**
     * @stability stable
     */
    get encodingInput(): string | undefined;
    private _errorOnColumnCountMismatch?;
    /**
     * @stability stable
     */
    get errorOnColumnCountMismatch(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set errorOnColumnCountMismatch(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetErrorOnColumnCountMismatch(): void;
    /**
     * @stability stable
     */
    get errorOnColumnCountMismatchInput(): boolean | cdktf.IResolvable | undefined;
    private _escape?;
    /**
     * @stability stable
     */
    get escape(): string;
    /**
     * @stability stable
     */
    set escape(value: string);
    /**
     * @stability stable
     */
    resetEscape(): void;
    /**
     * @stability stable
     */
    get escapeInput(): string | undefined;
    private _escapeUnenclosedField?;
    /**
     * @stability stable
     */
    get escapeUnenclosedField(): string;
    /**
     * @stability stable
     */
    set escapeUnenclosedField(value: string);
    /**
     * @stability stable
     */
    resetEscapeUnenclosedField(): void;
    /**
     * @stability stable
     */
    get escapeUnenclosedFieldInput(): string | undefined;
    private _fieldDelimiter?;
    /**
     * @stability stable
     */
    get fieldDelimiter(): string;
    /**
     * @stability stable
     */
    set fieldDelimiter(value: string);
    /**
     * @stability stable
     */
    resetFieldDelimiter(): void;
    /**
     * @stability stable
     */
    get fieldDelimiterInput(): string | undefined;
    private _fieldOptionallyEnclosedBy?;
    /**
     * @stability stable
     */
    get fieldOptionallyEnclosedBy(): string;
    /**
     * @stability stable
     */
    set fieldOptionallyEnclosedBy(value: string);
    /**
     * @stability stable
     */
    resetFieldOptionallyEnclosedBy(): void;
    /**
     * @stability stable
     */
    get fieldOptionallyEnclosedByInput(): string | undefined;
    private _fileExtension?;
    /**
     * @stability stable
     */
    get fileExtension(): string;
    /**
     * @stability stable
     */
    set fileExtension(value: string);
    /**
     * @stability stable
     */
    resetFileExtension(): void;
    /**
     * @stability stable
     */
    get fileExtensionInput(): string | undefined;
    private _formatType?;
    /**
     * @stability stable
     */
    get formatType(): string;
    /**
     * @stability stable
     */
    set formatType(value: string);
    /**
     * @stability stable
     */
    get formatTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ignoreUtf8Errors?;
    /**
     * @stability stable
     */
    get ignoreUtf8Errors(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ignoreUtf8Errors(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIgnoreUtf8Errors(): void;
    /**
     * @stability stable
     */
    get ignoreUtf8ErrorsInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nullIf?;
    /**
     * @stability stable
     */
    get nullIf(): string[];
    /**
     * @stability stable
     */
    set nullIf(value: string[]);
    /**
     * @stability stable
     */
    resetNullIf(): void;
    /**
     * @stability stable
     */
    get nullIfInput(): string[] | undefined;
    private _preserveSpace?;
    /**
     * @stability stable
     */
    get preserveSpace(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set preserveSpace(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPreserveSpace(): void;
    /**
     * @stability stable
     */
    get preserveSpaceInput(): boolean | cdktf.IResolvable | undefined;
    private _recordDelimiter?;
    /**
     * @stability stable
     */
    get recordDelimiter(): string;
    /**
     * @stability stable
     */
    set recordDelimiter(value: string);
    /**
     * @stability stable
     */
    resetRecordDelimiter(): void;
    /**
     * @stability stable
     */
    get recordDelimiterInput(): string | undefined;
    private _replaceInvalidCharacters?;
    /**
     * @stability stable
     */
    get replaceInvalidCharacters(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set replaceInvalidCharacters(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReplaceInvalidCharacters(): void;
    /**
     * @stability stable
     */
    get replaceInvalidCharactersInput(): boolean | cdktf.IResolvable | undefined;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    private _skipBlankLines?;
    /**
     * @stability stable
     */
    get skipBlankLines(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipBlankLines(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipBlankLines(): void;
    /**
     * @stability stable
     */
    get skipBlankLinesInput(): boolean | cdktf.IResolvable | undefined;
    private _skipByteOrderMark?;
    /**
     * @stability stable
     */
    get skipByteOrderMark(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipByteOrderMark(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipByteOrderMark(): void;
    /**
     * @stability stable
     */
    get skipByteOrderMarkInput(): boolean | cdktf.IResolvable | undefined;
    private _skipHeader?;
    /**
     * @stability stable
     */
    get skipHeader(): number;
    /**
     * @stability stable
     */
    set skipHeader(value: number);
    /**
     * @stability stable
     */
    resetSkipHeader(): void;
    /**
     * @stability stable
     */
    get skipHeaderInput(): number | undefined;
    private _stripNullValues?;
    /**
     * @stability stable
     */
    get stripNullValues(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set stripNullValues(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStripNullValues(): void;
    /**
     * @stability stable
     */
    get stripNullValuesInput(): boolean | cdktf.IResolvable | undefined;
    private _stripOuterArray?;
    /**
     * @stability stable
     */
    get stripOuterArray(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set stripOuterArray(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStripOuterArray(): void;
    /**
     * @stability stable
     */
    get stripOuterArrayInput(): boolean | cdktf.IResolvable | undefined;
    private _stripOuterElement?;
    /**
     * @stability stable
     */
    get stripOuterElement(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set stripOuterElement(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStripOuterElement(): void;
    /**
     * @stability stable
     */
    get stripOuterElementInput(): boolean | cdktf.IResolvable | undefined;
    private _timeFormat?;
    /**
     * @stability stable
     */
    get timeFormat(): string;
    /**
     * @stability stable
     */
    set timeFormat(value: string);
    /**
     * @stability stable
     */
    resetTimeFormat(): void;
    /**
     * @stability stable
     */
    get timeFormatInput(): string | undefined;
    private _timestampFormat?;
    /**
     * @stability stable
     */
    get timestampFormat(): string;
    /**
     * @stability stable
     */
    set timestampFormat(value: string);
    /**
     * @stability stable
     */
    resetTimestampFormat(): void;
    /**
     * @stability stable
     */
    get timestampFormatInput(): string | undefined;
    private _trimSpace?;
    /**
     * @stability stable
     */
    get trimSpace(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set trimSpace(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTrimSpace(): void;
    /**
     * @stability stable
     */
    get trimSpaceInput(): boolean | cdktf.IResolvable | undefined;
    private _validateUtf8?;
    /**
     * @stability stable
     */
    get validateUtf8(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set validateUtf8(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetValidateUtf8(): void;
    /**
     * @stability stable
     */
    get validateUtf8Input(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
