import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FunctionGrantConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the database containing the current or future functions on which to grant privileges.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#database_name FunctionGrant#database_name}
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * The name of the function on which to grant privileges immediately (only valid if on_future is false).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#function_name FunctionGrant#function_name}
     *
     * @stability stable
     */
    readonly functionName?: string;
    /**
     * When this is set to true and a schema_name is provided, apply this grant on all future functions in the given schema.
     *
     * When this is true and no schema_name is provided apply this grant on all future functions in the given database. The function_name, arguments, return_type, and shares fields must be unset in order to use on_future.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#on_future FunctionGrant#on_future}
     *
     * @stability stable
     */
    readonly onFuture?: boolean | cdktf.IResolvable;
    /**
     * The privilege to grant on the current or future function.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#privilege FunctionGrant#privilege}
     *
     * @stability stable
     */
    readonly privilege?: string;
    /**
     * The return type of the function (must be present if function_name is present).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#return_type FunctionGrant#return_type}
     *
     * @stability stable
     */
    readonly returnType?: string;
    /**
     * Grants privilege to these roles.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#roles FunctionGrant#roles}
     *
     * @stability stable
     */
    readonly roles?: string[];
    /**
     * The name of the schema containing the current or future functions on which to grant privileges.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#schema_name FunctionGrant#schema_name}
     *
     * @stability stable
     */
    readonly schemaName: string;
    /**
     * Grants privilege to these shares (only valid if on_future is false).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#shares FunctionGrant#shares}
     *
     * @stability stable
     */
    readonly shares?: string[];
    /**
     * When this is set to true, allows the recipient role to grant the privileges to other roles.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#with_grant_option FunctionGrant#with_grant_option}
     *
     * @stability stable
     */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
    /**
     * arguments block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#arguments FunctionGrant#arguments}
     *
     * @stability stable
     */
    readonly arguments?: FunctionGrantArguments[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface FunctionGrantArguments {
    /**
     * The argument name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#name FunctionGrant#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The argument type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant#type FunctionGrant#type}
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function functionGrantArgumentsToTerraform(struct?: FunctionGrantArguments | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant snowflake_function_grant}.
 *
 * @stability stable
 */
export declare class FunctionGrant extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/function_grant snowflake_function_grant} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FunctionGrantConfig);
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _functionName?;
    /**
     * @stability stable
     */
    get functionName(): string;
    /**
     * @stability stable
     */
    set functionName(value: string);
    /**
     * @stability stable
     */
    resetFunctionName(): void;
    /**
     * @stability stable
     */
    get functionNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _onFuture?;
    /**
     * @stability stable
     */
    get onFuture(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set onFuture(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOnFuture(): void;
    /**
     * @stability stable
     */
    get onFutureInput(): boolean | cdktf.IResolvable | undefined;
    private _privilege?;
    /**
     * @stability stable
     */
    get privilege(): string;
    /**
     * @stability stable
     */
    set privilege(value: string);
    /**
     * @stability stable
     */
    resetPrivilege(): void;
    /**
     * @stability stable
     */
    get privilegeInput(): string | undefined;
    private _returnType?;
    /**
     * @stability stable
     */
    get returnType(): string;
    /**
     * @stability stable
     */
    set returnType(value: string);
    /**
     * @stability stable
     */
    resetReturnType(): void;
    /**
     * @stability stable
     */
    get returnTypeInput(): string | undefined;
    private _roles?;
    /**
     * @stability stable
     */
    get roles(): string[];
    /**
     * @stability stable
     */
    set roles(value: string[]);
    /**
     * @stability stable
     */
    resetRoles(): void;
    /**
     * @stability stable
     */
    get rolesInput(): string[] | undefined;
    private _schemaName?;
    /**
     * @stability stable
     */
    get schemaName(): string;
    /**
     * @stability stable
     */
    set schemaName(value: string);
    /**
     * @stability stable
     */
    get schemaNameInput(): string | undefined;
    private _shares?;
    /**
     * @stability stable
     */
    get shares(): string[];
    /**
     * @stability stable
     */
    set shares(value: string[]);
    /**
     * @stability stable
     */
    resetShares(): void;
    /**
     * @stability stable
     */
    get sharesInput(): string[] | undefined;
    private _withGrantOption?;
    /**
     * @stability stable
     */
    get withGrantOption(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set withGrantOption(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWithGrantOption(): void;
    /**
     * @stability stable
     */
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    private _arguments?;
    /**
     * @stability stable
     */
    get arguments(): FunctionGrantArguments[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set arguments(value: FunctionGrantArguments[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetArguments(): void;
    /**
     * @stability stable
     */
    get argumentsInput(): cdktf.IResolvable | FunctionGrantArguments[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
