import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FunctionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies a comment for the function.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function#comment Function#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * The database in which to create the function. Don't use the | character.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function#database Function#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * the handler method for Java function.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function#handler Function#handler}
     *
     * @stability stable
     */
    readonly handler?: string;
    /**
     * jar files to import for Java function.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function#imports Function#imports}
     *
     * @stability stable
     */
    readonly imports?: string[];
    /**
     * The language of the statement.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function#language Function#language}
     *
     * @stability stable
     */
    readonly language?: string;
    /**
     * Specifies the identifier for the function;
     *
     * does not have to be unique for the schema in which the function is created. Don't use the | character.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function#name Function#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Specifies the behavior of the function when called with null inputs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function#null_input_behavior Function#null_input_behavior}
     *
     * @stability stable
     */
    readonly nullInputBehavior?: string;
    /**
     * Specifies the behavior of the function when returning results.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function#return_behavior Function#return_behavior}
     *
     * @stability stable
     */
    readonly returnBehavior?: string;
    /**
     * The return type of the function.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function#return_type Function#return_type}
     *
     * @stability stable
     */
    readonly returnType: string;
    /**
     * The schema in which to create the function. Don't use the | character.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function#schema Function#schema}
     *
     * @stability stable
     */
    readonly schema: string;
    /**
     * Specifies the javascript / java / sql code used to create the function.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function#statement Function#statement}
     *
     * @stability stable
     */
    readonly statement: string;
    /**
     * the target path for compiled jar file for Java function.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function#target_path Function#target_path}
     *
     * @stability stable
     */
    readonly targetPath?: string;
    /**
     * arguments block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function#arguments Function#arguments}
     *
     * @stability stable
     */
    readonly arguments?: FunctionArguments[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface FunctionArguments {
    /**
     * The argument name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function#name Function#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The argument type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/function#type Function#type}
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function functionArgumentsToTerraform(struct?: FunctionArguments | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/function snowflake_function}.
 *
 * @stability stable
 */
export declare class Function extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/function snowflake_function} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FunctionConfig);
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    private _handler?;
    /**
     * @stability stable
     */
    get handler(): string;
    /**
     * @stability stable
     */
    set handler(value: string);
    /**
     * @stability stable
     */
    resetHandler(): void;
    /**
     * @stability stable
     */
    get handlerInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _imports?;
    /**
     * @stability stable
     */
    get imports(): string[];
    /**
     * @stability stable
     */
    set imports(value: string[]);
    /**
     * @stability stable
     */
    resetImports(): void;
    /**
     * @stability stable
     */
    get importsInput(): string[] | undefined;
    private _language?;
    /**
     * @stability stable
     */
    get language(): string;
    /**
     * @stability stable
     */
    set language(value: string);
    /**
     * @stability stable
     */
    resetLanguage(): void;
    /**
     * @stability stable
     */
    get languageInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nullInputBehavior?;
    /**
     * @stability stable
     */
    get nullInputBehavior(): string;
    /**
     * @stability stable
     */
    set nullInputBehavior(value: string);
    /**
     * @stability stable
     */
    resetNullInputBehavior(): void;
    /**
     * @stability stable
     */
    get nullInputBehaviorInput(): string | undefined;
    private _returnBehavior?;
    /**
     * @stability stable
     */
    get returnBehavior(): string;
    /**
     * @stability stable
     */
    set returnBehavior(value: string);
    /**
     * @stability stable
     */
    resetReturnBehavior(): void;
    /**
     * @stability stable
     */
    get returnBehaviorInput(): string | undefined;
    private _returnType?;
    /**
     * @stability stable
     */
    get returnType(): string;
    /**
     * @stability stable
     */
    set returnType(value: string);
    /**
     * @stability stable
     */
    get returnTypeInput(): string | undefined;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    private _statement?;
    /**
     * @stability stable
     */
    get statement(): string;
    /**
     * @stability stable
     */
    set statement(value: string);
    /**
     * @stability stable
     */
    get statementInput(): string | undefined;
    private _targetPath?;
    /**
     * @stability stable
     */
    get targetPath(): string;
    /**
     * @stability stable
     */
    set targetPath(value: string);
    /**
     * @stability stable
     */
    resetTargetPath(): void;
    /**
     * @stability stable
     */
    get targetPathInput(): string | undefined;
    private _arguments?;
    /**
     * @stability stable
     */
    get arguments(): FunctionArguments[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set arguments(value: FunctionArguments[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetArguments(): void;
    /**
     * @stability stable
     */
    get argumentsInput(): cdktf.IResolvable | FunctionArguments[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
