import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ManagedAccountConfig extends cdktf.TerraformMetaArguments {
    /**
     * Identifier, as well as login name, for the initial user in the managed account.
     *
     * This user serves as the account administrator for the account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/managed_account#admin_name ManagedAccount#admin_name}
     *
     * @stability stable
     */
    readonly adminName: string;
    /**
     * Password for the initial user in the managed account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/managed_account#admin_password ManagedAccount#admin_password}
     *
     * @stability stable
     */
    readonly adminPassword: string;
    /**
     * Specifies a comment for the managed account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/managed_account#comment ManagedAccount#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * Identifier for the managed account; must be unique for your account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/managed_account#name ManagedAccount#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Specifies the type of managed account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/managed_account#type ManagedAccount#type}
     *
     * @stability stable
     */
    readonly type?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/managed_account snowflake_managed_account}.
 *
 * @stability stable
 */
export declare class ManagedAccount extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/managed_account snowflake_managed_account} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ManagedAccountConfig);
    private _adminName?;
    /**
     * @stability stable
     */
    get adminName(): string;
    /**
     * @stability stable
     */
    set adminName(value: string);
    /**
     * @stability stable
     */
    get adminNameInput(): string | undefined;
    private _adminPassword?;
    /**
     * @stability stable
     */
    get adminPassword(): string;
    /**
     * @stability stable
     */
    set adminPassword(value: string);
    /**
     * @stability stable
     */
    get adminPasswordInput(): string | undefined;
    /**
     * @stability stable
     */
    get cloud(): string;
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    /**
     * @stability stable
     */
    get createdOn(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get locator(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get region(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
