import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MaskingPolicyGrantConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the database containing the masking policy on which to grant privileges.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy_grant#database_name MaskingPolicyGrant#database_name}
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * The name of the masking policy on which to grant privileges immediately.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy_grant#masking_policy_name MaskingPolicyGrant#masking_policy_name}
     *
     * @stability stable
     */
    readonly maskingPolicyName: string;
    /**
     * The privilege to grant on the masking policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy_grant#privilege MaskingPolicyGrant#privilege}
     *
     * @stability stable
     */
    readonly privilege?: string;
    /**
     * Grants privilege to these roles.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy_grant#roles MaskingPolicyGrant#roles}
     *
     * @stability stable
     */
    readonly roles?: string[];
    /**
     * The name of the schema containing the masking policy on which to grant privileges.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy_grant#schema_name MaskingPolicyGrant#schema_name}
     *
     * @stability stable
     */
    readonly schemaName: string;
    /**
     * When this is set to true, allows the recipient role to grant the privileges to other roles.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy_grant#with_grant_option MaskingPolicyGrant#with_grant_option}
     *
     * @stability stable
     */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy_grant snowflake_masking_policy_grant}.
 *
 * @stability stable
 */
export declare class MaskingPolicyGrant extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy_grant snowflake_masking_policy_grant} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MaskingPolicyGrantConfig);
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _maskingPolicyName?;
    /**
     * @stability stable
     */
    get maskingPolicyName(): string;
    /**
     * @stability stable
     */
    set maskingPolicyName(value: string);
    /**
     * @stability stable
     */
    get maskingPolicyNameInput(): string | undefined;
    private _privilege?;
    /**
     * @stability stable
     */
    get privilege(): string;
    /**
     * @stability stable
     */
    set privilege(value: string);
    /**
     * @stability stable
     */
    resetPrivilege(): void;
    /**
     * @stability stable
     */
    get privilegeInput(): string | undefined;
    private _roles?;
    /**
     * @stability stable
     */
    get roles(): string[];
    /**
     * @stability stable
     */
    set roles(value: string[]);
    /**
     * @stability stable
     */
    resetRoles(): void;
    /**
     * @stability stable
     */
    get rolesInput(): string[] | undefined;
    private _schemaName?;
    /**
     * @stability stable
     */
    get schemaName(): string;
    /**
     * @stability stable
     */
    set schemaName(value: string);
    /**
     * @stability stable
     */
    get schemaNameInput(): string | undefined;
    private _withGrantOption?;
    /**
     * @stability stable
     */
    get withGrantOption(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set withGrantOption(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWithGrantOption(): void;
    /**
     * @stability stable
     */
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
