import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MaskingPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies a comment for the masking policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy#comment MaskingPolicy#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * The database in which to create the masking policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy#database MaskingPolicy#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * Specifies the SQL expression that transforms the data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy#masking_expression MaskingPolicy#masking_expression}
     *
     * @stability stable
     */
    readonly maskingExpression: string;
    /**
     * Specifies the identifier for the masking policy;
     *
     * must be unique for the database and schema in which the masking policy is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy#name MaskingPolicy#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Specifies the data type to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy#return_data_type MaskingPolicy#return_data_type}
     *
     * @stability stable
     */
    readonly returnDataType: string;
    /**
     * The schema in which to create the masking policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy#schema MaskingPolicy#schema}
     *
     * @stability stable
     */
    readonly schema: string;
    /**
     * Specifies the data type to mask.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy#value_data_type MaskingPolicy#value_data_type}
     *
     * @stability stable
     */
    readonly valueDataType: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy snowflake_masking_policy}.
 *
 * @stability stable
 */
export declare class MaskingPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy snowflake_masking_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MaskingPolicyConfig);
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _maskingExpression?;
    /**
     * @stability stable
     */
    get maskingExpression(): string;
    /**
     * @stability stable
     */
    set maskingExpression(value: string);
    /**
     * @stability stable
     */
    get maskingExpressionInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _returnDataType?;
    /**
     * @stability stable
     */
    get returnDataType(): string;
    /**
     * @stability stable
     */
    set returnDataType(value: string);
    /**
     * @stability stable
     */
    get returnDataTypeInput(): string | undefined;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    private _valueDataType?;
    /**
     * @stability stable
     */
    get valueDataType(): string;
    /**
     * @stability stable
     */
    set valueDataType(value: string);
    /**
     * @stability stable
     */
    get valueDataTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
