import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MaterializedViewConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies a comment for the view.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#comment MaterializedView#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * The database in which to create the view. Don't use the | character.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#database MaterializedView#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * Specifies that the view is secure.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#is_secure MaterializedView#is_secure}
     *
     * @stability stable
     */
    readonly isSecure?: boolean | cdktf.IResolvable;
    /**
     * Specifies the identifier for the view; must be unique for the schema in which the view is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#name MaterializedView#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Overwrites the View if it exists.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#or_replace MaterializedView#or_replace}
     *
     * @stability stable
     */
    readonly orReplace?: boolean | cdktf.IResolvable;
    /**
     * The schema in which to create the view. Don't use the | character.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#schema MaterializedView#schema}
     *
     * @stability stable
     */
    readonly schema: string;
    /**
     * Specifies the query used to create the view.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#statement MaterializedView#statement}
     *
     * @stability stable
     */
    readonly statement: string;
    /**
     * The warehouse name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#warehouse MaterializedView#warehouse}
     *
     * @stability stable
     */
    readonly warehouse: string;
    /**
     * tag block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#tag MaterializedView#tag}
     *
     * @stability stable
     */
    readonly tag?: MaterializedViewTag[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface MaterializedViewTag {
    /**
     * Name of the database that the tag was created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#database MaterializedView#database}
     *
     * @stability stable
     */
    readonly database?: string;
    /**
     * Tag name, e.g. department.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#name MaterializedView#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of the schema that the tag was created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#schema MaterializedView#schema}
     *
     * @stability stable
     */
    readonly schema?: string;
    /**
     * Tag value, e.g. marketing_info.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view#value MaterializedView#value}
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function materializedViewTagToTerraform(struct?: MaterializedViewTag | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view snowflake_materialized_view}.
 *
 * @stability stable
 */
export declare class MaterializedView extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/materialized_view snowflake_materialized_view} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MaterializedViewConfig);
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _isSecure?;
    /**
     * @stability stable
     */
    get isSecure(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isSecure(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsSecure(): void;
    /**
     * @stability stable
     */
    get isSecureInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _orReplace?;
    /**
     * @stability stable
     */
    get orReplace(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set orReplace(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOrReplace(): void;
    /**
     * @stability stable
     */
    get orReplaceInput(): boolean | cdktf.IResolvable | undefined;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    private _statement?;
    /**
     * @stability stable
     */
    get statement(): string;
    /**
     * @stability stable
     */
    set statement(value: string);
    /**
     * @stability stable
     */
    get statementInput(): string | undefined;
    private _warehouse?;
    /**
     * @stability stable
     */
    get warehouse(): string;
    /**
     * @stability stable
     */
    set warehouse(value: string);
    /**
     * @stability stable
     */
    get warehouseInput(): string | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): MaterializedViewTag[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tag(value: MaterializedViewTag[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): cdktf.IResolvable | MaterializedViewTag[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
