import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkPolicyAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies the identifier for the network policy;
     *
     * must be unique for the account in which the network policy is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/network_policy_attachment#network_policy_name NetworkPolicyAttachment#network_policy_name}
     *
     * @stability stable
     */
    readonly networkPolicyName: string;
    /**
     * Specifies whether the network policy should be applied globally to your Snowflake account<br><br>**Note:** The Snowflake user running `terraform apply` must be on an IP address allowed by the network policy to set that policy globally on the Snowflake account.<br><br>Additionally, a Snowflake account can only have one network policy set globally at any given time. This resource does not enforce one-policy-per-account, it is the user's responsibility to enforce this. If multiple network policy resources have `set_for_account: true`, the final policy set on the account will be non-deterministic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/network_policy_attachment#set_for_account NetworkPolicyAttachment#set_for_account}
     *
     * @stability stable
     */
    readonly setForAccount?: boolean | cdktf.IResolvable;
    /**
     * Specifies which users the network policy should be attached to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/network_policy_attachment#users NetworkPolicyAttachment#users}
     *
     * @stability stable
     */
    readonly users?: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/network_policy_attachment snowflake_network_policy_attachment}.
 *
 * @stability stable
 */
export declare class NetworkPolicyAttachment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/network_policy_attachment snowflake_network_policy_attachment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkPolicyAttachmentConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _networkPolicyName?;
    /**
     * @stability stable
     */
    get networkPolicyName(): string;
    /**
     * @stability stable
     */
    set networkPolicyName(value: string);
    /**
     * @stability stable
     */
    get networkPolicyNameInput(): string | undefined;
    private _setForAccount?;
    /**
     * @stability stable
     */
    get setForAccount(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set setForAccount(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSetForAccount(): void;
    /**
     * @stability stable
     */
    get setForAccountInput(): boolean | cdktf.IResolvable | undefined;
    private _users?;
    /**
     * @stability stable
     */
    get users(): string[];
    /**
     * @stability stable
     */
    set users(value: string[]);
    /**
     * @stability stable
     */
    resetUsers(): void;
    /**
     * @stability stable
     */
    get usersInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
