import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies one or more IPv4 addresses (CIDR notation) that are allowed access to your Snowflake account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/network_policy#allowed_ip_list NetworkPolicy#allowed_ip_list}
     *
     * @stability stable
     */
    readonly allowedIpList: string[];
    /**
     * Specifies one or more IPv4 addresses (CIDR notation) that are denied access to your Snowflake account<br><br>**Do not** add `0.0.0.0/0` to `blocked_ip_list`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/network_policy#blocked_ip_list NetworkPolicy#blocked_ip_list}
     *
     * @stability stable
     */
    readonly blockedIpList?: string[];
    /**
     * Specifies a comment for the network policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/network_policy#comment NetworkPolicy#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * Specifies the identifier for the network policy;
     *
     * must be unique for the account in which the network policy is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/network_policy#name NetworkPolicy#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/network_policy snowflake_network_policy}.
 *
 * @stability stable
 */
export declare class NetworkPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/network_policy snowflake_network_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkPolicyConfig);
    private _allowedIpList?;
    /**
     * @stability stable
     */
    get allowedIpList(): string[];
    /**
     * @stability stable
     */
    set allowedIpList(value: string[]);
    /**
     * @stability stable
     */
    get allowedIpListInput(): string[] | undefined;
    private _blockedIpList?;
    /**
     * @stability stable
     */
    get blockedIpList(): string[];
    /**
     * @stability stable
     */
    set blockedIpList(value: string[]);
    /**
     * @stability stable
     */
    resetBlockedIpList(): void;
    /**
     * @stability stable
     */
    get blockedIpListInput(): string[] | undefined;
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
