import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NotificationIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
     * AWS IAM role ARN for notification integration to assume.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#aws_sns_role_arn NotificationIntegration#aws_sns_role_arn}
     *
     * @stability stable
     */
    readonly awsSnsRoleArn?: string;
    /**
     * AWS SNS Topic ARN for notification integration to connect to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#aws_sns_topic_arn NotificationIntegration#aws_sns_topic_arn}
     *
     * @stability stable
     */
    readonly awsSnsTopicArn?: string;
    /**
     * AWS SQS queue ARN for notification integration to connect to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#aws_sqs_arn NotificationIntegration#aws_sqs_arn}
     *
     * @stability stable
     */
    readonly awsSqsArn?: string;
    /**
     * AWS IAM role ARN for notification integration to assume.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#aws_sqs_role_arn NotificationIntegration#aws_sqs_role_arn}
     *
     * @stability stable
     */
    readonly awsSqsRoleArn?: string;
    /**
     * The queue ID for the Azure Queue Storage queue created for Event Grid notifications.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#azure_storage_queue_primary_uri NotificationIntegration#azure_storage_queue_primary_uri}
     *
     * @stability stable
     */
    readonly azureStorageQueuePrimaryUri?: string;
    /**
     * The ID of the Azure Active Directory tenant used for identity management.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#azure_tenant_id NotificationIntegration#azure_tenant_id}
     *
     * @stability stable
     */
    readonly azureTenantId?: string;
    /**
     * A comment for the integration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#comment NotificationIntegration#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * Direction of the cloud messaging with respect to Snowflake (required only for error notifications).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#direction NotificationIntegration#direction}
     *
     * @stability stable
     */
    readonly direction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#enabled NotificationIntegration#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * The subscription id that Snowflake will listen to when using the GCP_PUBSUB provider.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#gcp_pubsub_subscription_name NotificationIntegration#gcp_pubsub_subscription_name}
     *
     * @stability stable
     */
    readonly gcpPubsubSubscriptionName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#name NotificationIntegration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The third-party cloud message queuing service (e.g. AZURE_STORAGE_QUEUE, AWS_SQS, AWS_SNS).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#notification_provider NotificationIntegration#notification_provider}
     *
     * @stability stable
     */
    readonly notificationProvider?: string;
    /**
     * A type of integration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#type NotificationIntegration#type}
     *
     * @stability stable
     */
    readonly type?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration snowflake_notification_integration}.
 *
 * @stability stable
 */
export declare class NotificationIntegration extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration snowflake_notification_integration} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NotificationIntegrationConfig);
    /**
     * @stability stable
     */
    get awsSnsExternalId(): string;
    /**
     * @stability stable
     */
    get awsSnsIamUserArn(): string;
    private _awsSnsRoleArn?;
    /**
     * @stability stable
     */
    get awsSnsRoleArn(): string;
    /**
     * @stability stable
     */
    set awsSnsRoleArn(value: string);
    /**
     * @stability stable
     */
    resetAwsSnsRoleArn(): void;
    /**
     * @stability stable
     */
    get awsSnsRoleArnInput(): string | undefined;
    private _awsSnsTopicArn?;
    /**
     * @stability stable
     */
    get awsSnsTopicArn(): string;
    /**
     * @stability stable
     */
    set awsSnsTopicArn(value: string);
    /**
     * @stability stable
     */
    resetAwsSnsTopicArn(): void;
    /**
     * @stability stable
     */
    get awsSnsTopicArnInput(): string | undefined;
    private _awsSqsArn?;
    /**
     * @stability stable
     */
    get awsSqsArn(): string;
    /**
     * @stability stable
     */
    set awsSqsArn(value: string);
    /**
     * @stability stable
     */
    resetAwsSqsArn(): void;
    /**
     * @stability stable
     */
    get awsSqsArnInput(): string | undefined;
    /**
     * @stability stable
     */
    get awsSqsExternalId(): string;
    /**
     * @stability stable
     */
    get awsSqsIamUserArn(): string;
    private _awsSqsRoleArn?;
    /**
     * @stability stable
     */
    get awsSqsRoleArn(): string;
    /**
     * @stability stable
     */
    set awsSqsRoleArn(value: string);
    /**
     * @stability stable
     */
    resetAwsSqsRoleArn(): void;
    /**
     * @stability stable
     */
    get awsSqsRoleArnInput(): string | undefined;
    private _azureStorageQueuePrimaryUri?;
    /**
     * @stability stable
     */
    get azureStorageQueuePrimaryUri(): string;
    /**
     * @stability stable
     */
    set azureStorageQueuePrimaryUri(value: string);
    /**
     * @stability stable
     */
    resetAzureStorageQueuePrimaryUri(): void;
    /**
     * @stability stable
     */
    get azureStorageQueuePrimaryUriInput(): string | undefined;
    private _azureTenantId?;
    /**
     * @stability stable
     */
    get azureTenantId(): string;
    /**
     * @stability stable
     */
    set azureTenantId(value: string);
    /**
     * @stability stable
     */
    resetAzureTenantId(): void;
    /**
     * @stability stable
     */
    get azureTenantIdInput(): string | undefined;
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    /**
     * @stability stable
     */
    get createdOn(): string;
    private _direction?;
    /**
     * @stability stable
     */
    get direction(): string;
    /**
     * @stability stable
     */
    set direction(value: string);
    /**
     * @stability stable
     */
    resetDirection(): void;
    /**
     * @stability stable
     */
    get directionInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _gcpPubsubSubscriptionName?;
    /**
     * @stability stable
     */
    get gcpPubsubSubscriptionName(): string;
    /**
     * @stability stable
     */
    set gcpPubsubSubscriptionName(value: string);
    /**
     * @stability stable
     */
    resetGcpPubsubSubscriptionName(): void;
    /**
     * @stability stable
     */
    get gcpPubsubSubscriptionNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _notificationProvider?;
    /**
     * @stability stable
     */
    get notificationProvider(): string;
    /**
     * @stability stable
     */
    set notificationProvider(value: string);
    /**
     * @stability stable
     */
    resetNotificationProvider(): void;
    /**
     * @stability stable
     */
    get notificationProviderInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
