import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface OauthIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
     * List of roles that a user cannot explicitly consent to using after authenticating.
     *
     * Do not include ACCOUNTADMIN, ORGADMIN or SECURITYADMIN as they are already implicitly enforced and will cause in-place updates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/oauth_integration#blocked_roles_list OauthIntegration#blocked_roles_list}
     *
     * @stability stable
     */
    readonly blockedRolesList?: string[];
    /**
     * Specifies a comment for the OAuth integration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/oauth_integration#comment OauthIntegration#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * Specifies whether this OAuth integration is enabled or disabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/oauth_integration#enabled OauthIntegration#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Specifies the name of the OAuth integration.
     *
     * This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/oauth_integration#name OauthIntegration#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Specifies the OAuth client type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/oauth_integration#oauth_client OauthIntegration#oauth_client}
     *
     * @stability stable
     */
    readonly oauthClient: string;
    /**
     * Specifies whether to allow the client to exchange a refresh token for an access token when the current access token has expired.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/oauth_integration#oauth_issue_refresh_tokens OauthIntegration#oauth_issue_refresh_tokens}
     *
     * @stability stable
     */
    readonly oauthIssueRefreshTokens?: boolean | cdktf.IResolvable;
    /**
     * Specifies how long refresh tokens should be valid (in seconds). OAUTH_ISSUE_REFRESH_TOKENS must be set to TRUE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/oauth_integration#oauth_refresh_token_validity OauthIntegration#oauth_refresh_token_validity}
     *
     * @stability stable
     */
    readonly oauthRefreshTokenValidity?: number;
    /**
     * Specifies whether default secondary roles set in the user properties are activated by default in the session being opened.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/oauth_integration#oauth_use_secondary_roles OauthIntegration#oauth_use_secondary_roles}
     *
     * @stability stable
     */
    readonly oauthUseSecondaryRoles?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/oauth_integration snowflake_oauth_integration}.
 *
 * @stability stable
 */
export declare class OauthIntegration extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/oauth_integration snowflake_oauth_integration} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: OauthIntegrationConfig);
    private _blockedRolesList?;
    /**
     * @stability stable
     */
    get blockedRolesList(): string[];
    /**
     * @stability stable
     */
    set blockedRolesList(value: string[]);
    /**
     * @stability stable
     */
    resetBlockedRolesList(): void;
    /**
     * @stability stable
     */
    get blockedRolesListInput(): string[] | undefined;
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    /**
     * @stability stable
     */
    get createdOn(): string;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _oauthClient?;
    /**
     * @stability stable
     */
    get oauthClient(): string;
    /**
     * @stability stable
     */
    set oauthClient(value: string);
    /**
     * @stability stable
     */
    get oauthClientInput(): string | undefined;
    private _oauthIssueRefreshTokens?;
    /**
     * @stability stable
     */
    get oauthIssueRefreshTokens(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set oauthIssueRefreshTokens(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOauthIssueRefreshTokens(): void;
    /**
     * @stability stable
     */
    get oauthIssueRefreshTokensInput(): boolean | cdktf.IResolvable | undefined;
    private _oauthRefreshTokenValidity?;
    /**
     * @stability stable
     */
    get oauthRefreshTokenValidity(): number;
    /**
     * @stability stable
     */
    set oauthRefreshTokenValidity(value: number);
    /**
     * @stability stable
     */
    resetOauthRefreshTokenValidity(): void;
    /**
     * @stability stable
     */
    get oauthRefreshTokenValidityInput(): number | undefined;
    private _oauthUseSecondaryRoles?;
    /**
     * @stability stable
     */
    get oauthUseSecondaryRoles(): string;
    /**
     * @stability stable
     */
    set oauthUseSecondaryRoles(value: string);
    /**
     * @stability stable
     */
    resetOauthUseSecondaryRoles(): void;
    /**
     * @stability stable
     */
    get oauthUseSecondaryRolesInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
