import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PipeConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies a auto_ingest param for the pipe.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe#auto_ingest Pipe#auto_ingest}
     *
     * @stability stable
     */
    readonly autoIngest?: boolean | cdktf.IResolvable;
    /**
     * Specifies the Amazon Resource Name (ARN) for the SNS topic for your S3 bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe#aws_sns_topic_arn Pipe#aws_sns_topic_arn}
     *
     * @stability stable
     */
    readonly awsSnsTopicArn?: string;
    /**
     * Specifies a comment for the pipe.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe#comment Pipe#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * Specifies the copy statement for the pipe.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe#copy_statement Pipe#copy_statement}
     *
     * @stability stable
     */
    readonly copyStatement: string;
    /**
     * The database in which to create the pipe.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe#database Pipe#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * Specifies the name of the notification integration used for error notifications.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe#error_integration Pipe#error_integration}
     *
     * @stability stable
     */
    readonly errorIntegration?: string;
    /**
     * Specifies an integration for the pipe.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe#integration Pipe#integration}
     *
     * @stability stable
     */
    readonly integration?: string;
    /**
     * Specifies the identifier for the pipe;
     *
     * must be unique for the database and schema in which the pipe is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe#name Pipe#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The schema in which to create the pipe.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe#schema Pipe#schema}
     *
     * @stability stable
     */
    readonly schema: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/pipe snowflake_pipe}.
 *
 * @stability stable
 */
export declare class Pipe extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/pipe snowflake_pipe} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PipeConfig);
    private _autoIngest?;
    /**
     * @stability stable
     */
    get autoIngest(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoIngest(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoIngest(): void;
    /**
     * @stability stable
     */
    get autoIngestInput(): boolean | cdktf.IResolvable | undefined;
    private _awsSnsTopicArn?;
    /**
     * @stability stable
     */
    get awsSnsTopicArn(): string;
    /**
     * @stability stable
     */
    set awsSnsTopicArn(value: string);
    /**
     * @stability stable
     */
    resetAwsSnsTopicArn(): void;
    /**
     * @stability stable
     */
    get awsSnsTopicArnInput(): string | undefined;
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    private _copyStatement?;
    /**
     * @stability stable
     */
    get copyStatement(): string;
    /**
     * @stability stable
     */
    set copyStatement(value: string);
    /**
     * @stability stable
     */
    get copyStatementInput(): string | undefined;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    private _errorIntegration?;
    /**
     * @stability stable
     */
    get errorIntegration(): string;
    /**
     * @stability stable
     */
    set errorIntegration(value: string);
    /**
     * @stability stable
     */
    resetErrorIntegration(): void;
    /**
     * @stability stable
     */
    get errorIntegrationInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _integration?;
    /**
     * @stability stable
     */
    get integration(): string;
    /**
     * @stability stable
     */
    set integration(value: string);
    /**
     * @stability stable
     */
    resetIntegration(): void;
    /**
     * @stability stable
     */
    get integrationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get notificationChannel(): string;
    /**
     * @stability stable
     */
    get owner(): string;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
