import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ProcedureGrantConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the database containing the current or future procedures on which to grant privileges.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#database_name ProcedureGrant#database_name}
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * When this is set to true and a schema_name is provided, apply this grant on all future procedures in the given schema.
     *
     * When this is true and no schema_name is provided apply this grant on all future procedures in the given database. The procedure_name and shares fields must be unset in order to use on_future.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#on_future ProcedureGrant#on_future}
     *
     * @stability stable
     */
    readonly onFuture?: boolean | cdktf.IResolvable;
    /**
     * The privilege to grant on the current or future procedure.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#privilege ProcedureGrant#privilege}
     *
     * @stability stable
     */
    readonly privilege?: string;
    /**
     * The name of the procedure on which to grant privileges immediately (only valid if on_future is false).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#procedure_name ProcedureGrant#procedure_name}
     *
     * @stability stable
     */
    readonly procedureName?: string;
    /**
     * The return type of the procedure (must be present if procedure_name is present).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#return_type ProcedureGrant#return_type}
     *
     * @stability stable
     */
    readonly returnType?: string;
    /**
     * Grants privilege to these roles.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#roles ProcedureGrant#roles}
     *
     * @stability stable
     */
    readonly roles?: string[];
    /**
     * The name of the schema containing the current or future procedures on which to grant privileges.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#schema_name ProcedureGrant#schema_name}
     *
     * @stability stable
     */
    readonly schemaName: string;
    /**
     * Grants privilege to these shares (only valid if on_future is false).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#shares ProcedureGrant#shares}
     *
     * @stability stable
     */
    readonly shares?: string[];
    /**
     * When this is set to true, allows the recipient role to grant the privileges to other roles.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#with_grant_option ProcedureGrant#with_grant_option}
     *
     * @stability stable
     */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
    /**
     * arguments block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#arguments ProcedureGrant#arguments}
     *
     * @stability stable
     */
    readonly arguments?: ProcedureGrantArguments[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface ProcedureGrantArguments {
    /**
     * The argument name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#name ProcedureGrant#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The argument type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#type ProcedureGrant#type}
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function procedureGrantArgumentsToTerraform(struct?: ProcedureGrantArguments | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant snowflake_procedure_grant}.
 *
 * @stability stable
 */
export declare class ProcedureGrant extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant snowflake_procedure_grant} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ProcedureGrantConfig);
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _onFuture?;
    /**
     * @stability stable
     */
    get onFuture(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set onFuture(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOnFuture(): void;
    /**
     * @stability stable
     */
    get onFutureInput(): boolean | cdktf.IResolvable | undefined;
    private _privilege?;
    /**
     * @stability stable
     */
    get privilege(): string;
    /**
     * @stability stable
     */
    set privilege(value: string);
    /**
     * @stability stable
     */
    resetPrivilege(): void;
    /**
     * @stability stable
     */
    get privilegeInput(): string | undefined;
    private _procedureName?;
    /**
     * @stability stable
     */
    get procedureName(): string;
    /**
     * @stability stable
     */
    set procedureName(value: string);
    /**
     * @stability stable
     */
    resetProcedureName(): void;
    /**
     * @stability stable
     */
    get procedureNameInput(): string | undefined;
    private _returnType?;
    /**
     * @stability stable
     */
    get returnType(): string;
    /**
     * @stability stable
     */
    set returnType(value: string);
    /**
     * @stability stable
     */
    resetReturnType(): void;
    /**
     * @stability stable
     */
    get returnTypeInput(): string | undefined;
    private _roles?;
    /**
     * @stability stable
     */
    get roles(): string[];
    /**
     * @stability stable
     */
    set roles(value: string[]);
    /**
     * @stability stable
     */
    resetRoles(): void;
    /**
     * @stability stable
     */
    get rolesInput(): string[] | undefined;
    private _schemaName?;
    /**
     * @stability stable
     */
    get schemaName(): string;
    /**
     * @stability stable
     */
    set schemaName(value: string);
    /**
     * @stability stable
     */
    get schemaNameInput(): string | undefined;
    private _shares?;
    /**
     * @stability stable
     */
    get shares(): string[];
    /**
     * @stability stable
     */
    set shares(value: string[]);
    /**
     * @stability stable
     */
    resetShares(): void;
    /**
     * @stability stable
     */
    get sharesInput(): string[] | undefined;
    private _withGrantOption?;
    /**
     * @stability stable
     */
    get withGrantOption(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set withGrantOption(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWithGrantOption(): void;
    /**
     * @stability stable
     */
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    private _arguments?;
    /**
     * @stability stable
     */
    get arguments(): ProcedureGrantArguments[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set arguments(value: ProcedureGrantArguments[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetArguments(): void;
    /**
     * @stability stable
     */
    get argumentsInput(): cdktf.IResolvable | ProcedureGrantArguments[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
