import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ProcedureConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies a comment for the procedure.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#comment Procedure#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * The database in which to create the procedure. Don't use the | character.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#database Procedure#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * Sets execute context - see caller's rights and owner's rights.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#execute_as Procedure#execute_as}
     *
     * @stability stable
     */
    readonly executeAs?: string;
    /**
     * Specifies the identifier for the procedure;
     *
     * does not have to be unique for the schema in which the procedure is created. Don't use the | character.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#name Procedure#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Specifies the behavior of the procedure when called with null inputs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#null_input_behavior Procedure#null_input_behavior}
     *
     * @stability stable
     */
    readonly nullInputBehavior?: string;
    /**
     * Specifies the behavior of the function when returning results.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#return_behavior Procedure#return_behavior}
     *
     * @stability stable
     */
    readonly returnBehavior?: string;
    /**
     * The return type of the procedure.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#return_type Procedure#return_type}
     *
     * @stability stable
     */
    readonly returnType: string;
    /**
     * The schema in which to create the procedure. Don't use the | character.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#schema Procedure#schema}
     *
     * @stability stable
     */
    readonly schema: string;
    /**
     * Specifies the javascript code used to create the procedure.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#statement Procedure#statement}
     *
     * @stability stable
     */
    readonly statement: string;
    /**
     * arguments block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#arguments Procedure#arguments}
     *
     * @stability stable
     */
    readonly arguments?: ProcedureArguments[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface ProcedureArguments {
    /**
     * The argument name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#name Procedure#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The argument type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#type Procedure#type}
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function procedureArgumentsToTerraform(struct?: ProcedureArguments | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/procedure snowflake_procedure}.
 *
 * @stability stable
 */
export declare class Procedure extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/procedure snowflake_procedure} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ProcedureConfig);
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    private _executeAs?;
    /**
     * @stability stable
     */
    get executeAs(): string;
    /**
     * @stability stable
     */
    set executeAs(value: string);
    /**
     * @stability stable
     */
    resetExecuteAs(): void;
    /**
     * @stability stable
     */
    get executeAsInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nullInputBehavior?;
    /**
     * @stability stable
     */
    get nullInputBehavior(): string;
    /**
     * @stability stable
     */
    set nullInputBehavior(value: string);
    /**
     * @stability stable
     */
    resetNullInputBehavior(): void;
    /**
     * @stability stable
     */
    get nullInputBehaviorInput(): string | undefined;
    private _returnBehavior?;
    /**
     * @stability stable
     */
    get returnBehavior(): string;
    /**
     * @stability stable
     */
    set returnBehavior(value: string);
    /**
     * @stability stable
     */
    resetReturnBehavior(): void;
    /**
     * @stability stable
     */
    get returnBehaviorInput(): string | undefined;
    private _returnType?;
    /**
     * @stability stable
     */
    get returnType(): string;
    /**
     * @stability stable
     */
    set returnType(value: string);
    /**
     * @stability stable
     */
    get returnTypeInput(): string | undefined;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    private _statement?;
    /**
     * @stability stable
     */
    get statement(): string;
    /**
     * @stability stable
     */
    set statement(value: string);
    /**
     * @stability stable
     */
    get statementInput(): string | undefined;
    private _arguments?;
    /**
     * @stability stable
     */
    get arguments(): ProcedureArguments[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set arguments(value: ProcedureArguments[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetArguments(): void;
    /**
     * @stability stable
     */
    get argumentsInput(): cdktf.IResolvable | ProcedureArguments[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
