import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ResourceMonitorGrantConfig extends cdktf.TerraformMetaArguments {
    /**
     * Identifier for the resource monitor; must be unique for your account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor_grant#monitor_name ResourceMonitorGrant#monitor_name}
     *
     * @stability stable
     */
    readonly monitorName: string;
    /**
     * The privilege to grant on the resource monitor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor_grant#privilege ResourceMonitorGrant#privilege}
     *
     * @stability stable
     */
    readonly privilege?: string;
    /**
     * Grants privilege to these roles.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor_grant#roles ResourceMonitorGrant#roles}
     *
     * @stability stable
     */
    readonly roles?: string[];
    /**
     * When this is set to true, allows the recipient role to grant the privileges to other roles.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor_grant#with_grant_option ResourceMonitorGrant#with_grant_option}
     *
     * @stability stable
     */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor_grant snowflake_resource_monitor_grant}.
 *
 * @stability stable
 */
export declare class ResourceMonitorGrant extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor_grant snowflake_resource_monitor_grant} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ResourceMonitorGrantConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _monitorName?;
    /**
     * @stability stable
     */
    get monitorName(): string;
    /**
     * @stability stable
     */
    set monitorName(value: string);
    /**
     * @stability stable
     */
    get monitorNameInput(): string | undefined;
    private _privilege?;
    /**
     * @stability stable
     */
    get privilege(): string;
    /**
     * @stability stable
     */
    set privilege(value: string);
    /**
     * @stability stable
     */
    resetPrivilege(): void;
    /**
     * @stability stable
     */
    get privilegeInput(): string | undefined;
    private _roles?;
    /**
     * @stability stable
     */
    get roles(): string[];
    /**
     * @stability stable
     */
    set roles(value: string[]);
    /**
     * @stability stable
     */
    resetRoles(): void;
    /**
     * @stability stable
     */
    get rolesInput(): string[] | undefined;
    private _withGrantOption?;
    /**
     * @stability stable
     */
    get withGrantOption(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set withGrantOption(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWithGrantOption(): void;
    /**
     * @stability stable
     */
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
