import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ResourceMonitorConfig extends cdktf.TerraformMetaArguments {
    /**
     * The number of credits allocated monthly to the resource monitor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#credit_quota ResourceMonitor#credit_quota}
     *
     * @stability stable
     */
    readonly creditQuota?: number;
    /**
     * The date and time when the resource monitor suspends the assigned warehouses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#end_timestamp ResourceMonitor#end_timestamp}
     *
     * @stability stable
     */
    readonly endTimestamp?: string;
    /**
     * The frequency interval at which the credit usage resets to 0.
     *
     * If you set a frequency for a resource monitor, you must also set START_TIMESTAMP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#frequency ResourceMonitor#frequency}
     *
     * @stability stable
     */
    readonly frequency?: string;
    /**
     * Identifier for the resource monitor; must be unique for your account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#name ResourceMonitor#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * A list of percentage thresholds at which to send an alert to subscribed users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#notify_triggers ResourceMonitor#notify_triggers}
     *
     * @stability stable
     */
    readonly notifyTriggers?: number[];
    /**
     * Specifies whether the resource monitor should be applied globally to your Snowflake account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#set_for_account ResourceMonitor#set_for_account}
     *
     * @stability stable
     */
    readonly setForAccount?: boolean | cdktf.IResolvable;
    /**
     * The date and time when the resource monitor starts monitoring credit usage for the assigned warehouses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#start_timestamp ResourceMonitor#start_timestamp}
     *
     * @stability stable
     */
    readonly startTimestamp?: string;
    /**
     * A list of percentage thresholds at which to immediately suspend all warehouses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#suspend_immediate_triggers ResourceMonitor#suspend_immediate_triggers}
     *
     * @stability stable
     */
    readonly suspendImmediateTriggers?: number[];
    /**
     * A list of percentage thresholds at which to suspend all warehouses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#suspend_triggers ResourceMonitor#suspend_triggers}
     *
     * @stability stable
     */
    readonly suspendTriggers?: number[];
    /**
     * A list of warehouses to apply the resource monitor to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#warehouses ResourceMonitor#warehouses}
     *
     * @stability stable
     */
    readonly warehouses?: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor snowflake_resource_monitor}.
 *
 * @stability stable
 */
export declare class ResourceMonitor extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor snowflake_resource_monitor} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ResourceMonitorConfig);
    private _creditQuota?;
    /**
     * @stability stable
     */
    get creditQuota(): number;
    /**
     * @stability stable
     */
    set creditQuota(value: number);
    /**
     * @stability stable
     */
    resetCreditQuota(): void;
    /**
     * @stability stable
     */
    get creditQuotaInput(): number | undefined;
    private _endTimestamp?;
    /**
     * @stability stable
     */
    get endTimestamp(): string;
    /**
     * @stability stable
     */
    set endTimestamp(value: string);
    /**
     * @stability stable
     */
    resetEndTimestamp(): void;
    /**
     * @stability stable
     */
    get endTimestampInput(): string | undefined;
    private _frequency?;
    /**
     * @stability stable
     */
    get frequency(): string;
    /**
     * @stability stable
     */
    set frequency(value: string);
    /**
     * @stability stable
     */
    resetFrequency(): void;
    /**
     * @stability stable
     */
    get frequencyInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _notifyTriggers?;
    /**
     * @stability stable
     */
    get notifyTriggers(): number[];
    /**
     * @stability stable
     */
    set notifyTriggers(value: number[]);
    /**
     * @stability stable
     */
    resetNotifyTriggers(): void;
    /**
     * @stability stable
     */
    get notifyTriggersInput(): number[] | undefined;
    private _setForAccount?;
    /**
     * @stability stable
     */
    get setForAccount(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set setForAccount(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSetForAccount(): void;
    /**
     * @stability stable
     */
    get setForAccountInput(): boolean | cdktf.IResolvable | undefined;
    private _startTimestamp?;
    /**
     * @stability stable
     */
    get startTimestamp(): string;
    /**
     * @stability stable
     */
    set startTimestamp(value: string);
    /**
     * @stability stable
     */
    resetStartTimestamp(): void;
    /**
     * @stability stable
     */
    get startTimestampInput(): string | undefined;
    private _suspendImmediateTriggers?;
    /**
     * @stability stable
     */
    get suspendImmediateTriggers(): number[];
    /**
     * @stability stable
     */
    set suspendImmediateTriggers(value: number[]);
    /**
     * @stability stable
     */
    resetSuspendImmediateTriggers(): void;
    /**
     * @stability stable
     */
    get suspendImmediateTriggersInput(): number[] | undefined;
    private _suspendTriggers?;
    /**
     * @stability stable
     */
    get suspendTriggers(): number[];
    /**
     * @stability stable
     */
    set suspendTriggers(value: number[]);
    /**
     * @stability stable
     */
    resetSuspendTriggers(): void;
    /**
     * @stability stable
     */
    get suspendTriggersInput(): number[] | undefined;
    private _warehouses?;
    /**
     * @stability stable
     */
    get warehouses(): string[];
    /**
     * @stability stable
     */
    set warehouses(value: string[]);
    /**
     * @stability stable
     */
    resetWarehouses(): void;
    /**
     * @stability stable
     */
    get warehousesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
