import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RoleGrantsConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the role we are granting.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/role_grants#role_name RoleGrants#role_name}
     *
     * @stability stable
     */
    readonly roleName: string;
    /**
     * Grants role to this specified role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/role_grants#roles RoleGrants#roles}
     *
     * @stability stable
     */
    readonly roles?: string[];
    /**
     * Grants role to this specified user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/role_grants#users RoleGrants#users}
     *
     * @stability stable
     */
    readonly users?: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/role_grants snowflake_role_grants}.
 *
 * @stability stable
 */
export declare class RoleGrants extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/role_grants snowflake_role_grants} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RoleGrantsConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _roleName?;
    /**
     * @stability stable
     */
    get roleName(): string;
    /**
     * @stability stable
     */
    set roleName(value: string);
    /**
     * @stability stable
     */
    get roleNameInput(): string | undefined;
    private _roles?;
    /**
     * @stability stable
     */
    get roles(): string[];
    /**
     * @stability stable
     */
    set roles(value: string[]);
    /**
     * @stability stable
     */
    resetRoles(): void;
    /**
     * @stability stable
     */
    get rolesInput(): string[] | undefined;
    private _users?;
    /**
     * @stability stable
     */
    get users(): string[];
    /**
     * @stability stable
     */
    set users(value: string[]);
    /**
     * @stability stable
     */
    resetUsers(): void;
    /**
     * @stability stable
     */
    get usersInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
