import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RowAccessPolicyGrantConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the database containing the row access policy on which to grant privileges.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy_grant#database_name RowAccessPolicyGrant#database_name}
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * The privilege to grant on the row access policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy_grant#privilege RowAccessPolicyGrant#privilege}
     *
     * @stability stable
     */
    readonly privilege?: string;
    /**
     * Grants privilege to these roles.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy_grant#roles RowAccessPolicyGrant#roles}
     *
     * @stability stable
     */
    readonly roles?: string[];
    /**
     * The name of the row access policy on which to grant privileges immediately.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy_grant#row_access_policy_name RowAccessPolicyGrant#row_access_policy_name}
     *
     * @stability stable
     */
    readonly rowAccessPolicyName: string;
    /**
     * The name of the schema containing the row access policy on which to grant privileges.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy_grant#schema_name RowAccessPolicyGrant#schema_name}
     *
     * @stability stable
     */
    readonly schemaName: string;
    /**
     * When this is set to true, allows the recipient role to grant the privileges to other roles.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy_grant#with_grant_option RowAccessPolicyGrant#with_grant_option}
     *
     * @stability stable
     */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy_grant snowflake_row_access_policy_grant}.
 *
 * @stability stable
 */
export declare class RowAccessPolicyGrant extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy_grant snowflake_row_access_policy_grant} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RowAccessPolicyGrantConfig);
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _privilege?;
    /**
     * @stability stable
     */
    get privilege(): string;
    /**
     * @stability stable
     */
    set privilege(value: string);
    /**
     * @stability stable
     */
    resetPrivilege(): void;
    /**
     * @stability stable
     */
    get privilegeInput(): string | undefined;
    private _roles?;
    /**
     * @stability stable
     */
    get roles(): string[];
    /**
     * @stability stable
     */
    set roles(value: string[]);
    /**
     * @stability stable
     */
    resetRoles(): void;
    /**
     * @stability stable
     */
    get rolesInput(): string[] | undefined;
    private _rowAccessPolicyName?;
    /**
     * @stability stable
     */
    get rowAccessPolicyName(): string;
    /**
     * @stability stable
     */
    set rowAccessPolicyName(value: string);
    /**
     * @stability stable
     */
    get rowAccessPolicyNameInput(): string | undefined;
    private _schemaName?;
    /**
     * @stability stable
     */
    get schemaName(): string;
    /**
     * @stability stable
     */
    set schemaName(value: string);
    /**
     * @stability stable
     */
    get schemaNameInput(): string | undefined;
    private _withGrantOption?;
    /**
     * @stability stable
     */
    get withGrantOption(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set withGrantOption(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWithGrantOption(): void;
    /**
     * @stability stable
     */
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
