import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RowAccessPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies a comment for the row access policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy#comment RowAccessPolicy#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * The database in which to create the row access policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy#database RowAccessPolicy#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * Specifies the identifier for the row access policy;
     *
     * must be unique for the database and schema in which the row access policy is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy#name RowAccessPolicy#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Specifies the SQL expression. The expression can be any boolean-valued SQL expression.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy#row_access_expression RowAccessPolicy#row_access_expression}
     *
     * @stability stable
     */
    readonly rowAccessExpression: string;
    /**
     * The schema in which to create the row access policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy#schema RowAccessPolicy#schema}
     *
     * @stability stable
     */
    readonly schema: string;
    /**
     * Specifies signature (arguments) for the row access policy (uppercase and sorted to avoid recreation of resource).
     *
     * A signature specifies a set of attributes that must be considered to determine whether the row is accessible. The attribute values come from the database object (e.g. table or view) to be protected by the row access policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy#signature RowAccessPolicy#signature}
     *
     * @stability stable
     */
    readonly signature: {
        [key: string]: string;
    };
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy snowflake_row_access_policy}.
 *
 * @stability stable
 */
export declare class RowAccessPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy snowflake_row_access_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RowAccessPolicyConfig);
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _rowAccessExpression?;
    /**
     * @stability stable
     */
    get rowAccessExpression(): string;
    /**
     * @stability stable
     */
    set rowAccessExpression(value: string);
    /**
     * @stability stable
     */
    get rowAccessExpressionInput(): string | undefined;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    private _signature?;
    /**
     * @stability stable
     */
    get signature(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set signature(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    get signatureInput(): {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
